package Role::RebuildTables;

use Moose::Role;
use Data::Dumper;

sub rebuild_tables {
    my $self  = shift;
    my $table = shift; # scalar or arrayref

	if ( ref $table eq 'ARRAY' ) {
		$self->rebuild($_) foreach @$table;
	}
	else {
		$self->rebuild($table);
	}
}

sub rebuild_tables_asMyISAM {
	my $self = shift;
	my $tbl  = shift; # warn $tbl;    
    
    $self->rebuild($tbl); # just forward to rebuild() - make decision there	
}

sub convert_to_InnoDB {
	my $self = shift;
	my $tbl  = shift; # warn $tbl;    
	if ($ENV{HOST} && $ENV{HOST} eq 'hmds-lth') {
		my $dbh = $self->db->{dbh4};
		$dbh->do( qq!ALTER TABLE $tbl ENGINE="InnoDB"! );
	}
}

sub rebuild {
	my $self = shift;
	my $tbl  = shift; # warn $tbl;

    my $dbh = $self->db->{dbh4};

	my $sql = $self->sql->{table}->{$tbl};
	$sql =~ s/InnoDB/MyISAM/ if ($ENV{HOST} && $ENV{HOST} eq 'hmds-lth'); 
    $dbh->do( qq!DROP TABLE IF EXISTS `$tbl`! ); 
	$dbh->do( $sql );
}

sub clear_table {
	my ($self, $table) = @_;

    my $dbh = $self->db->{dbh4};

	$dbh->do( qq!TRUNCATE TABLE $table!);
	if ($ENV{HOST} && $ENV{HOST} eq 'hmds-lth') {
		$dbh->do( qq!ALTER TABLE $table ENGINE="MyISAM"! );
	}
}

1;
