package LIMS::Controller::Login;

use base 'LIMS::Base';

use Moose;
with (
	'LIMS::Controller::Roles::Resource',
);

has 'user_messages' => (
    traits  => ['Counter'],
    is      => 'ro',
    isa     => 'Num',
    default => 0,
    handles => {
        msg_counter => 'inc',
    }
);
__PACKAGE__->meta->make_immutable(inline_constructor => 0);

use LIMS::Local::Utils;
use Data::Dumper;

# this should not normally be called (ie/hmds/login), but just in case,
# load login.tt & display 'already logged in' message:
sub default : StartRunmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    return $self->tt_process();
}

sub logout : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    # tidy up:
    $self->authen->logout;
    $self->session_delete; # causes loss of any flash messages !!

    return $self->redirect( $self->query->url );
}

# redirection target if detected by authen->is_new_login:
sub hello : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    
    my $settings = $self->cfg('settings');
    my $profile  = $self->user_profile; # $self->debug($profile);
    
    # get users location from profile:
	my $user_location = $profile->{user_location}->{location_name};

    my $user_type = # is user internal or external?
        $user_location eq $settings->{lab_name_abbreviation}
        ? 'internal'
        : 'external';
    $self->tt_params( user_type => $user_type );

    # if any user-to-user messages:
    if ( my $messages = $self->get_user_messages($profile->{id}) ) {
        $self->msg_counter(scalar @{ $messages->{outbound} });
        $self->msg_counter(scalar @{ $messages->{inbound}  });
        $self->tt_params( user_messages => $messages );
    }
    # if any admin-to-user messages:
    if ( my $messages = $self->get_admin_messages($user_location) ) {  
        $self->msg_counter(scalar @$messages);
        $self->tt_params( admin_messages => $messages );
    }
    
    # convert profile last_login date to DT:
    if ( my $last_login = $profile->{last_login} ) { # maybe 1st login
        my $dt = LIMS::Local::Utils::to_datetime_using_parsedate($last_login);
        $self->tt_params( last_login => $dt );
    }
   	# if region_code exists in user profile, or has network, get new/relapsed diagnoses:
	if ( $user_type eq 'external' ) { # not required for lab staff
		my $org_code = $profile->{user_location}->{region_code}; # warn $org_code;
        my $get_all_cases = $settings->{login_display_all_cases};

        if ( my $locations = $self->get_network_locations ) { # C::R::Resource
			# replace $org_code with array(ref) of network locations:
            $org_code = [ map $locations->{$_}, keys %$locations ];
        }

        if ($org_code) { # may not exist eg user from NYCRIS, EGU, etc
            my %args = ( org_code => $org_code, all_cases => $get_all_cases );
            my $data = $self->new_and_relapsed_diagnoses(\%args);    
            $self->tt_params( results => $data->{results} );
        }
    } 
    if ( $settings->{have_online_requests} ) {
        my $token = $self->create_form_tokens();
        $self->tt_params( token => $token );
    }
    # if any messages or require new/relapsed diagnosis list:
    return $user_type eq 'external' || $self->user_messages
        ? $self->tt_process()
        : $self->redirect( $self->query->url ); # no messages & doesn't require new diags 
}

1;
