package LIMS::Controller::Admin;

use strict;

use base 'LIMS::Base';

##################### Runmodes #########################################
sub menu : StartRunmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

	return $self->forbidden() unless $self->user_can('do_admin');

    return $self->tt_process;
}

# ------------------------------------------------------------------------------
sub missing_data : Runmode {
	my $self = shift; $self->_debug_path($self->get_current_runmode);

	return $self->tt_process('site/message.tt');
}

################### Global #######################################
sub have_lab_sections {
	my $self = shift; $self->_debug_path('have_lab_sections');

    my $lab_sections = $self->model('LabSection')->get_lab_sections;

	return @$lab_sections ? 1 : 0;
}

# ------------------------------------------------------------------------------
sub have_diagnostic_categories {
	my $self = shift; $self->_debug_path('have_diagnostic_categories');

    my $categories = $self->model('Diagnosis')->get_diagnostic_categories;

	return @$categories ? 1 : 0;
}

# ------------------------------------------------------------------------------
sub have_request_audit_categories {
	my $self = shift; $self->_debug_path('have_request_audit_categories');

    my $categories = $self->model('RequestAudit')->get_audit_categories;

	return @$categories ? 1 : 0;
}

# ------------------------------------------------------------------------------
sub have_lab_tests {
	my $self = shift; $self->_debug_path('have_lab_sections');

    my $lab_tests = $self->model('LabTest')->get_lab_tests;

	return @$lab_tests ? 1 : 0;
}

=begin # replaced by $dfv->valid()
# ------------------------------------------------------------------------------
sub parse_input {
    my $self = shift; $self->_debug_path('parse_input');
    my $dfv  = shift;

    my $data = $dfv->valid || # ValidateRM/DFV should catch this, but:
        $self->stash( error_msg => $self->messages('missing_data') );

    if ( my $id = $self->param('id') ) {
        $data->{id} = $id;
    }

    return $data;
}
=cut
=begin # this is not safe as params not explicitly set can be parsed:
    my $q    = $self->query;
    my $vars = $q->Vars; # $self->debug( $vars );

    if ( grep $q->param($_) eq '', keys %$vars ) { # if one of params is missing:
        $self->stash( error_msg => $self->messages('missing_data') );
        return;
    }

    # THIS IS LETHAL IF USING (BROKEN) CAD::Server - persists over requests:
    $vars->{id} = $self->param('id') if $self->param('id');

    return $vars;
=cut

# ------------------------------------------------------------------------------
sub get_user_functions {
    my $self = shift; $self->_debug_path('get_user_functions');
    my $group_functions = shift;

    # array to contain composite user_functions data:
    my @functions;

    # grep function_id's from user_group_functions in list_mode:
    my @group_functions_ids = map { $_->function_id } @$group_functions;

    # get list of user_functions table data:
    my $functions = $self->model('User')->get_user_functions;

    foreach my $function( @$functions ) { # $self->debug($function->id);
        # mark user_function active if user_function.id in @group_functions_ids array:
        my $is_selected = grep { $function->id == $_, } @group_functions_ids;

       # take user_function data into temp hash:
       my %data = (
            id       => $function->id,
            name     => $function->function_name,
            detail   => $function->function_detail,
            active   => $function->active,
			selected => $is_selected,
        );

        # push temp hash into array:
        push @functions, \%data;
    }

    return \@functions;
}

1;
