package LIMS::DB::RequestHaematology;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'request_haematology',

    columns => [
        lab_number      => { type => 'character', length => 8, not_null => 1 },
        status          => { type => 'enum', check_in => [ 'verified', 'default' ],
                                default => 'default', not_null => 1 },
        pda             => { type => 'varchar', length => 6, not_null => 1 },
        wbc             => { type => 'character', length => 4, not_null => 1 },
        wbc_f           => { type => 'integer', not_null => 1 },
        rbc             => { type => 'character', length => 4, not_null => 1 },
        rbc_f           => { type => 'integer', not_null => 1 },
        hb              => { type => 'character', length => 4, not_null => 1 },
        hb_f            => { type => 'integer', not_null => 1 },
        hct             => { type => 'character', length => 4, not_null => 1 },
        hct_f           => { type => 'integer', not_null => 1 },
        mcv             => { type => 'character', length => 4, not_null => 1 },
        mcv_f           => { type => 'integer', not_null => 1 },
        mch             => { type => 'character', length => 4, not_null => 1 },
        mch_f           => { type => 'integer', not_null => 1 },
        mchc            => { type => 'character', length => 4, not_null => 1 },
        mchc_f          => { type => 'integer', not_null => 1 },
        plt             => { type => 'character', length => 4, not_null => 1 },
        plt_f           => { type => 'integer', not_null => 1 },
        lymph_percent   => { type => 'character', length => 4, not_null => 1 },
        lymph_percent_f => { type => 'integer', not_null => 1 },
        mixed_percent   => { type => 'character', length => 4, not_null => 1 },
        mixed_percent_f => { type => 'integer', not_null => 1 },
        neutr_percent   => { type => 'character', length => 4, not_null => 1 },
        neutr_percent_f => { type => 'integer', not_null => 1 },
        lymph           => { type => 'character', length => 4, not_null => 1 },
        lymph_f         => { type => 'integer', not_null => 1 },
        mixed           => { type => 'character', length => 4, not_null => 1 },
        mixed_f         => { type => 'integer', not_null => 1 },
        neutr           => { type => 'character', length => 4, not_null => 1 },
        neutr_f         => { type => 'integer', not_null => 1 },
        rdw_sd          => { type => 'character', length => 4, not_null => 1 },
        rdw_sd_f        => { type => 'integer', not_null => 1 },
        rdw_cv          => { type => 'character', length => 4, not_null => 1 },
        rdw_cv_f        => { type => 'integer', not_null => 1 },
        created_at      => { type => 'timestamp', not_null => 1 },
        updated         => { type => 'datetime', default => '0000-00-00 00:00:00', not_null => 1 },
    ],

    primary_key_columns => [ 'lab_number' ],
);

__PACKAGE__->meta->make_manager_class('request_haematology');

1;
