#!/usr/bin/perl

=begin -------------------------------------------------------------------------
list of unfixed histology specimens for requests authorised during past 7 days
=cut ---------------------------------------------------------------------------

use strict;
use warnings;

my $JUST_TESTING = 1; # email to ra.jones only

################################################################################
my @recipients = qw( wheeler raj );
my $duration = 7; # how many working days since report date
################################################################################

BEGIN {
    use FindBin qw($Bin); # warn $Bin;
    use lib (
        "$Bin/../../../lib",
        '/home/raj/perl5/lib/perl5',
    );
}

use DateTime;
use Data::Dumper;
use Date::Calc qw(Delta_Days);
use LIMS::Local::ScriptHelpers;

# get tools from LIMS::Local::ScriptHelpers:
my $tools = LIMS::Local::ScriptHelpers->new();

my $sql_lib = $tools->sql_lib();
my $config  = $tools->config(); 
my $dbix    = $tools->dbix();

my $query = $sql_lib->retr('unfixed_histology_specimens');
my $result = $dbix->query($query, $duration);

my $sql = q!select 1 from request_lab_test_status r join lab_tests l on
    (r.lab_test_id = l.id) where r.request_id = ? and l.test_name = 'fish'!;
    
my @rows = ();
while (my @vals = $result->list) { # warn Dumper $ref; next;
	# has FISH been requested:
    $dbix->query($sql, $vals[0])->into(my $fish);

    push @rows, [ @vals, $fish ? 'x' : ''];
} # warn Dumper \@rows;

my $dates = sprintf '%s to %s',
    DateTime->today->subtract(days => $duration)->dmy('.'),
    DateTime->today->subtract(days => 1)->dmy('.'); # warn $dates;
    
my %data = ( dates => $dates, rows => \@rows );

# template:
my $tt_file  = 'cron/histology_samples.tt';
my $message_body = $tools->process_template($tt_file, \%data);

my %mail = (		
    subject => "Histology unfixed samples - $dates",
    message => $message_body,
	config  => $config,
); # warn Dumper \%mail;

RECIPIENT:
foreach my $recipient (@recipients) {
	my $email = $tools->get_email_address($recipient) || next RECIPIENT; warn Dumper $email; next;
	next RECIPIENT if $JUST_TESTING && $email !~ /ra\.jones/;
	$mail{recipient} = $email;

	my $rtn = LIMS::Model::Email->send_message(\%mail);
	warn "Error in $0: $rtn" if $rtn;		
}
