#!/usr/bin/perl

# compresses and archives yyyy_mmdd_sql.log
# rotates debug.log, sql.txt & trace.log
# skips empty files using io($file)->size
# run from cron once per day eg 00:00

use strict;
use warnings;

BEGIN {
    use FindBin qw($Bin); # warn $Bin; exit;
    use lib '/home/raj/perl5/lib/perl5';
}

use IO::All;
use Logfile::Rotate;
use DateTime::Format::Strptime;
use IO::Compress::Gzip qw(gzip $GzipError);

my $path_to_logs = "$Bin/../../../logs";
my $archive = "$path_to_logs/old";

my $formatter = DateTime::Format::Strptime->new( pattern => '%Y_%m%d' );
my $yesterday = DateTime->today(formatter => $formatter)->subtract( days => 1 );

# yyyy_mmdd_sql.log ------------------------------------------------------------
my $src = sprintf '%s/%s_sql.log', $path_to_logs, $yesterday;
if ( -e $src ) { # if file exists:
    my $o = io($src);
    # compress and archive if has data:
    if ($o->size) {
        my $output = sprintf '%s/%s_sql.log.gz', $archive, $yesterday;
        my $input  = $o->name; # warn $input;

        my $status = gzip $input => $output, Minimal => 1 # avoids full path info
            or die "$0 - gzip failed: $GzipError\n";
        # `gzip -c $src > $output`; # system command alternative
    }
    $o->unlink; # archived if has data, deleted anyway
}

=begin sql.log (replaced by yyyy_mmdd_sql.log)
my $sql_log = "$path_to_logs/sql.log";

if ( io($sql_log)->size ) {
    Logfile::Rotate->new(
        File    => $sql_log,        # base filename
        Dir     => $archive,        # move old files to here
        Count   => 365,             # how many to keep before overwriting
        Gzip    => 'lib',           # use Compress::Zlib for compression (recommended)
        Flock   => 'yes',           # flock if supported
        Persist => 'yes',           # copy current logfile chown settings to any new log files
    )->rotate;
}
=cut

# debug.log --------------------------------------------------------------------
my $debug_file = "$path_to_logs/debug.log"; #

if ( io($debug_file)->size ) {
    Logfile::Rotate->new(
        File    => $debug_file,   # base filename
        Count   => 3,             # how many to keep before overwriting
        Flock   => 'yes',         # flock if supported
        Persist => 'yes',         # copy current logfile chown settings to any new log files
    )->rotate;
}

# sql.txt ----------------------------------------------------------------------
my $sql_file = "$path_to_logs/sql.txt";

if ( io($sql_file)->size ) {
    Logfile::Rotate->new(
        File    => $sql_file,     # base filename
        Count   => 3,             # how many to keep before overwriting
        Flock   => 'yes',         # flock if supported
        Persist => 'yes',         # copy current logfile chown settings to any new log files
    )->rotate;
}

# trace.log --------------------------------------------------------------------
my $dbi_trace = "$path_to_logs/trace.log";

if ( io($dbi_trace)->size ) {
    Logfile::Rotate->new(
        File    => $dbi_trace,    # base filename
        Dir     => $archive,      # move old files to here
        Count   => 365,           # how many to keep before overwriting
        Flock   => 'yes',         # flock if supported
        Persist => 'yes',         # copy current logfile chown settings to any new log files
    )->rotate;
}