package LIMS::Model::Storage;

use Moose;
extends 'LIMS::Model::Base';
use namespace::clean -except => 'meta';
__PACKAGE__->meta->make_immutable;

use Data::Dumper;

#-------------------------------------------------------------------------------
sub input_storage {
    my ($self, $params) = @_;
    
    # get specimen code => id map:
    my $o = LIMS::DB::Specimen::Manager->get_specimens();
    my %map = map { $_->sample_code => $_->id } @$o;
    
    # transfer required $params -> %data
    my %data = map { $_ => $params->{$_} } qw(request_id vial_id);
    # add specimen.id:
    my $specimen = $params->{specimen};
    $data{specimen_id} = $map{$specimen}; # warn Dumper \%data;
    
    my %args = ( class => 'RequestStorage', data  => \%data );
    
    return $self->update_object(\%args);
    
}

#-------------------------------------------------------------------------------
sub get_request_storage {
    my ($self, $request_id) = @_;
    
    my @args = (
        query => [ request_id => $request_id ],
        with_objects => 'specimen',
    );
    my $o = LIMS::DB::RequestStorage::Manager->get_objects(@args);
    return $o;
}

1;