package LIMS::Local::Debug;

use strict;
use warnings;

use Exporter;
use FileHandle;
use Data::Dumper;
use LIMS::Local::Config;

use vars qw( $fh1 $fh2 @EXPORT );

@EXPORT = qw( DEBUG ); # debug_path

sub import { goto &Exporter::import }

sub DEBUG {
    # don't want t/*.t output unless specifically requested:
    return if ($ENV{HARNESS_ACTIVE} && ! $ENV{DEBUG_ON});

	my $cfg = LIMS::Local::Config->instance;
    my $path = $cfg->{path_to_app_root}; # warn Dumper $path_to_app_root;

    unless ($fh1) { # debug.txt in overwrite mode:
        $fh1 = new FileHandle '>' . "$path/logs/debug.txt" or die $!;
    }
    unless ($fh2) { # debug.log in append mode:
        $fh2 = new FileHandle '>>' . "$path/logs/debug.log" or die $!;
    }

    warn Dumper @_; # send to stdout

    my $str = join '', map {
        ref $_ # use Data::Dumper if it's a ref/object:
            ? Dumper $_
            : $_ . "\n";
    } grep $_, @_; # ignore empty elements
    
    print $_ $str for ($fh1, $fh2); # print to both filehandles
    
    $fh1->flush; # for mod_perl
    $fh2->flush; # for mod_perl
}

=begin # using LIMS::Local::Config->instance now
# can't use LIMS::Utils version as LT use's this package
sub find_home { # warn Dumper \@INC;
    my $path_to_app;

    foreach (@INC) {
        if (-e "$_/script/lims_server.pl") { # warn 'PATH:', $_;
            $path_to_app = $_ and last;
        }
    }

    return $path_to_app;
}
=cut

1;