package LIMS::DB::EmailContact;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'email_contacts',

    columns => [
        id                 => { type => 'integer', not_null => 1 },
        display_name       => { type => 'varchar', default => '', length => 255, not_null => 1 },
        scope              => { type => 'enum',
                            check_in => [ 'department', 'hospital', 'organisation' ] },
        referral_source_id => { type => 'integer', default => '0', not_null => 1 },
        contact_address    => { type => 'varchar', default => '', length => 255, not_null => 1 },
        is_active          => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
        type               => { type => 'enum', check_in => [ 'mdt', 'report', 'other' ] },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'type', 'contact_address' ],

    foreign_keys => [
        referral_source => {
            class       => 'LIMS::DB::ReferralSource',
            key_columns => { referral_source_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('email_contacts');

1;
