#!/bin/sh

# RUN ON A TEST SERVER WITH UP-TO-DATE CLONE OF REQUIRED DB - SEE README.TXT

# copies cloned database (supplied from command-line switch) to anon_tmp db on localhost
# anonymises names, dob & nhs_numbers in patients table + patient_case.unit_numbers
# creates new output file as <source_db_anon>.gz in current dir

if [ $# -lt 3 ]
then
    echo "usage: $0 <source db name> <username> <password>"
    exit 0
fi

SRC_DB=$1
USERNAME=$2
PASSWORD=$3
SERVER=localhost
TMP_DB=anon_tmp
GZ=$SRC_DB.anonymised.sql

# echo "$SRC_DB"
# echo "$GZ"

mysql -u$USERNAME -p$PASSWORD -e "create database if not exists $TMP_DB"

mysqldump --opt --verbose -h $SERVER -u$USERNAME -p$PASSWORD $SRC_DB \
  --ignore-table=$SRC_DB.patient_bcr_abl \
  --ignore-table=$SRC.SRC_DB.patient_demographics \
  --ignore-table=$SRC_DB.patient_edits \
  --ignore-table=$SRC_DB.patient_notes \
  --ignore-table=$SRC_DB.pre_registration \
  --ignore-table=$SRC_DB.request_form \
  --ignore-table=$SRC_DB.request_storage_copy \
  --ignore-table=$SRC_DB.user_messages \
  --ignore-table=$SRC_DB._email_contacts \
| mysql -u$USERNAME -p$PASSWORD $TMP_DB

perl anonymise_db.pl $TMP_DB $SRC_DB

echo "compressing ......."

# -t = Do not write CREATE TABLE statements that re-create each dumped table
# -c = Use complete INSERT statements that include column names
mysqldump -u $USERNAME -p$PASSWORD $TMP_DB -c | gzip -9 - >$GZ.gz # -9 = best compression

mysql -u$USERNAME -p$PASSWORD -e "drop database $TMP_DB"

echo "done"
