package LIMS::DB::StorageRack;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup (
    table => 'storage_racks',

    columns => [
        id                  => { type => 'serial', not_null => 1 },
        plateId             => { type => 'varchar', length => 10 },
        storage_location    => { type => 'varchar', length => 50 },
        is_active => { type => 'enum', check_in => [ 'yes', 'no' ],
                      default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'plateId' ],

    relationships => [
        request_storage => {
            class      => 'LIMS::DB::RequestStorage',
            column_map => { id => 'rack_id' },
            type       => 'one to many',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('storage_racks');

1;
