package LIMS::Model::NGIS;

use Moose;
extends 'LIMS::Model::Base';
use namespace::clean -except => 'meta';
__PACKAGE__->meta->make_immutable;

use Data::Printer;

#-------------------------------------------------------------------------------
sub get_all_ngis_lab_tests {
    my $self = shift;

    my @args = (
        require_objects => [ 'lab_test' ],
    );
    my $data = LIMS::DB::NGISLabTest::Manager->get_objects(@args);
    return $data;
}

sub get_ngis_lab_tests {
    my ($self, $test_name) = @_; # p $test_name;
    my @args = (
        query => [ test_name => $test_name ],
        require_objects => [ 'lab_test' ],
    );
    my $data = LIMS::DB::NGISLabTest::Manager->get_objects(@args);
    return $data;
}

1;
