#!/bin/sh

# RUN ON LTH142343

# copies hilis3 from LTH142343 localhost into hilis3_tmp on localhost, and anonymises patient names, dob & case_numbers.
# creates .gz file in setup/

# can't run from HONG during working hrs - locks db up
# need to create NEWDB on localhost if not already present

SRC_USER=raj
SRC_PASS=adm1n
SRC=hilis3
#SERVER=192.168.1.100
SERVER=localhost
NEWDB=tmp
LOCAL_USER=raj
LOCAL_PASS=adm1n
GZ=hilis3_anonymised.sql

mysqldump --opt --verbose -h $SERVER -u $SRC_USER -p$SRC_PASS $SRC \
  --ignore-table=$SRC.PID_copy \
  --ignore-table=$SRC.PID_deleted \
  --ignore-table=$SRC.Log \
| mysql -u $LOCAL_USER -p$LOCAL_PASS $NEWDB

perl anonymise_hilis3.pl $NEWDB

# -t = Do not write CREATE TABLE statements that re-create each dumped table
# -c = Use complete INSERT statements that include column names
mysqldump -u $LOCAL_USER -p$LOCAL_PASS $NEWDB -c | gzip -9 - >$GZ.gz # -9 = best compression
# restore using mysql -u raj -padm1n dbname < src.sql

#gunzip $GZ.gz
#perl scaffold/scaffold_locations.pl $GZ
