package LIMS::DB::DiagnosisContextWarning;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup (
    table   => 'diagnosis_context_warnings',

    columns => [
        id          => { type => 'serial', not_null => 1 },
        description => { type => 'varchar', length => 255 },
        is_active   => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes' },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [ 'description' ],

    relationships => [
        diagnosis_objs => {
            map_class => 'LIMS::DB::ContextWarningDiagnosis',
            map_from  => 'context_warning',
            map_to    => 'diagnosis',
            type      => 'many to many',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('diagnosis_context_warnings');

1;
