package LIMS::DB::RequestForm;

use strict;
use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table => 'request_form',

    columns => [
        id              => { type => 'varchar' },
        last_name       => { type => 'varchar' },
        first_name      => { type => 'varchar' },
        dob             => { type => 'date'    },
        gender          => { type => 'enum', check_in => [ 'M', 'F', 'U' ] },
        nhs_number      => { type => 'varchar', length => 10 },
        patient_number  => { type => 'varchar' },
        location_name   => { type => 'varchar' },
        location_id     => { type => 'integer' },
        referrer        => { type => 'varchar' },
        pds_code        => { type => 'varchar' },
        created         => { type => 'timestamp' },
        imported        => { type => 'datetime' },
    ],

    primary_key_columns => [ 'id' ],

);

__PACKAGE__->meta->make_manager_class('request_forms');

1;
