#!/usr/bin/env perl
#===============================================================================
#
#        USAGE: ./test_data_extra.pl  
#
#  DESCRIPTION: 
#===============================================================================

use Modern::Perl;
use utf8;

use DateTime;
use Digest::SHA1 'sha1_base64';


my $NOW = DateTime->now();

$TEST_DATA = {
    users => {
        fields => [ qw( username last_name first_name email user_location_id
            designation group_id active password ) ],
        values => [
            [ qw(raj jones richard raj@here.com 1 administrator 1 yes ),
                Digest::SHA1::sha1_base64('raj')], 
            [ qw(garryq quested garry garryq@here.com 1 administrator 1 yes ),
                Digest::SHA1::sha1_base64('garryq')], 
        ]
    },



    rfc => {
        fields => [ qw( reason details status user_id) ],
        values => [
            [ qw( modification b pending 1) ], # bodged users.id
            [ 'change menu', qw( e pending 2) ],
        ]
    },
};
