SET FOREIGN_KEY_CHECKS = 0;
RENAME TABLE bristol.screens TO screens_new;
CREATE TABLE bristol.screens (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `description` varchar(50) DEFAULT NULL,
  `sample_type` enum('fresh','fixed') DEFAULT NULL,
  `active` enum('yes','no') DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

RENAME TABLE bristol.request_diagnosis_history TO request_diagnosis_history_new;

DROP TABLE bristol.error_code_assignment;
CREATE TABLE bristol.error_code_assignment (
  `type` enum('patient','request','errors') DEFAULT NULL,
  `error_code_id` smallint(6) NOT NULL DEFAULT '0',
  UNIQUE KEY `error_code_type` (`type`,`error_code_id`),
  KEY `error_code_id` (`error_code_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE bristol.request_report (
  `request_id` int(11) NOT NULL,
  `comment` text,
  `clinical_details` text,
  `status` enum('new','relapse','default') NOT NULL DEFAULT 'default',
  `specimen_quality` enum('good','adequate','poor') NOT NULL DEFAULT 'adequate',
  `diagnosis_id` smallint(6) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`request_id`),
  KEY `request_report_ibfk_2` (`diagnosis_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE bristol.request_gross_description (
  `request_id` int(11) NOT NULL DEFAULT '0',
  `detail` text,
  PRIMARY KEY (`request_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET FOREIGN_KEY_CHECKS = 1;
