#!/usr/bin/perl

BEGIN { 
    use FindBin qw($Bin); # warn 'BIN:'.$Bin;
    use lib (
        '/home/raj/perl5/lib/perl5',
        "$Bin/../lib",
    );
}

use Data::Dumper;
use LIMS::Local::Utils;
use LIMS::Local::Config;

my $cfg = LIMS::Local::Config->instance;
    
my $filename = $ARGV[0];
unless ($filename) {
	print "usage: $0 <yaml filename>\n";
	exit;
}
$filename =~ s/\.yml//; # don't need suffix (if supplied)
die "no such file $filename" 
	unless -e join '/', $cfg->{path_to_app_root}, 'config/settings',
		$cfg->{settings}->{yaml_dir}, $filename . '.yml';

my %args = (
    yaml_dir => $cfg->{settings}->{yaml_dir},
    app_root => $cfg->{path_to_app_root},
    filename => $filename,
);
my $yaml = LIMS::Local::Utils::get_yaml(\%args);

if ($yaml) {
    warn Dumper $yaml;
}
else {
    print "$filename.yml file failed to parse!!!!\n";
}