package LIMS::DB::RequestInitialScreen;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'request_initial_screen',

    columns => [
        request_id => { type => 'integer', not_null => 1 },
        screen_id  => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },

        screen => {
            class       => 'LIMS::DB::Screen',
            key_columns => { screen_id => 'id' },
        },
    ],
);

# or to see what it should be:
#__PACKAGE__->meta->table('trials');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 4);

__PACKAGE__->meta->make_manager_class('request_inital_screen');

1;