package LIMS::DB::Outreach::QuestionnaireEQ5D;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    schema  => 'outreach',
    
    table   => 'questionnaire_eq5d',
    
    columns => [
        request_id     => { type => 'integer', not_null => 1 },
        mobility       => { type => 'enum', check_in => [ 'A', 'B', 'C' ] },
        self_care      => { type => 'enum', check_in => [ 'A', 'B', 'C' ] },
        usual_activity => { type => 'enum', check_in => [ 'A', 'B', 'C' ] },
        discomfort     => { type => 'enum', check_in => [ 'A', 'B', 'C' ] },
        anxiety        => { type => 'enum', check_in => [ 'A', 'B', 'C' ] },
        health_index   => { type => 'integer' }
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);
#=cut

__PACKAGE__->meta->make_manager_class('questionnaire_eq5d');

1;
