package LIMS::Controller::Admin::Config::ReportNotifications;

use base 'LIMS::Base';
use LIMS::Local::Sugar;

use strict;
use warnings;
use Data::Dumper;

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

# -------------------------------------------------------------------------------------
startmode default ($errs) {
    $self->_debug_path($self->get_current_runmode); # $self->stash(errs => $errs);

    my $email_contacts = $self->model('Notification')->get_all_contacts;
    my $departments    = $self->_get_hospital_departments();

    my $model = $self->model('ReferralSource');
    my $get_ref_src = sub { $model->get_referral_source(@_)->display_name };
    my $get_parent  = sub { $model->get_parent_organisation(@_)->description };

    $self->tt_params(
		email_contacts => $email_contacts,
        departments    => $departments,
        get_ref_src    => \&$get_ref_src,
        get_parent     => \&$get_parent,
	);

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('report_notifications');

    return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
runmode edit ($errs, $id) {
    $self->_debug_path($self->get_current_runmode); $self->stash(errs => $errs);

    $id || return $self->error('no id passed to '.$self->get_current_runmode);  # $self->debug('id:'.$id);

    my $departments  = $self->_get_hospital_departments();
    my $data         = $self->model('Notification')->get_contact($id);

    $self->tt_params(
        departments => $departments,
		data        => $data,
	);

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('report_notifications');

    return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
runmode update ($id) {
    $self->_debug_path($self->get_current_runmode);

	# if param 'id' passed, return error to edit():
    my $error_rm = $id ? 'edit' : 'default';

	my $dfv = $self->check_rm($error_rm, $self->validate('report_notifications') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid
    || return $self->forward('default'); # eg if empty param

    # referral_source_id only supplied if location changed, otherwise id supplied
    # in hidden _referral_source_id input:
    $data->{referral_source_id} ||= delete $data->{_referral_source_id}
        if $data->{type} ne 'referrer';

    # identifer supplied if referrer, otherwise need a location id:
    if ( $data->{type} eq 'hospital' )  { # use referral_source_id as identifier:
        $data->{identifier} = delete $data->{referral_source_id};
    }
    # if type = 'organisation', need to get ref_src parent_org id for identifier:
    elsif ( $data->{type} eq 'organisation' ) {
        my $src_id = delete $data->{referral_source_id};
        my $o = $self->model('ReferralSource')->get_referral_source($src_id);
        $data->{identifier} = $o->parent_organisation_id;
    } # warn Dumper $data;

	# provide 'id' if supplied, so record updated, otherwise new one created:
	if ($id) {
		$data->{id} = $id;
	}

    my $rtn = $self->model('Notification')->update_contact($data); # warn $rtn;

    if ($rtn) {
        $self->error($rtn);
	}
	else {
		$self->flash( info => $self->messages('action')->{edit_success} );
        $self->redirect( $self->query->url . '/config/report-notifications' );
    }
}

# not using Moose so can't use Role::DataMap (needs to be a runmode to get $self):
runmode _get_hospital_departments {
    my $o = $self->model('Referrer')->get_hospital_departments;
    my %map = map { $_->display_name => $_->id } @$o;
    return \%map;
}

1;
