package LIMS::Controller::Admin::User::Location;

use strict;

use base 'LIMS::Controller::Admin';

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

#-------------------------------------------------------------------------------
sub default : StartRunmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    my $errs = shift;

    # get list of functions table data:
    my $locations = $self->model('User')->get_user_locations();

	$self->tt_params( locations => $locations );

    # get js validation foo_onsubmit & foo_dfv_js vars into template:
    $self->js_validation_profile('user_locations');

    return $self->tt_process($errs);
}

#-------------------------------------------------------------------------------
sub edit : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    my $errs = shift;

    my $id = $self->param('id') || return $self->error('no id passed to '.$self->get_current_runmode); # $self->debug('id:'.$id);

    my $location = $self->model('User')->get_user_location($id);

    $self->tt_params( location => $location );

    # get js validation foo_onsubmit & foo_dfv_js vars into template:
    $self->js_validation_profile('user_locations');

    return $self->tt_process($errs);
}

#-------------------------------------------------------------------------------
sub update : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

	my $id = $self->param('id');
	
	# put id (if submitted) into params() as _record_id for validation:	
    if ( $id ) { 
        $self->query->param( _record_id => $id );
    }

    # if param 'id' passed, return error to edit():
    my $error_rm = $id ? 'edit' : 'default';

	my $dfv = $self->check_rm($error_rm, $self->validate('user_locations') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid
	|| return $self->forward('default'); # eg if empty param;

	# provide 'id' if supplied, so record updated, otherwise new one created: 
	if ($id) { $data->{id} = $id; }

    my $rtn = $self->model('User')->update_user_locations($data); 

    return $rtn ?
        $self->error($rtn) :
            $self->redirect( $self->query->url . '/admin/user_location' ); # safer to redirect after db edit
}

1;