package LIMS::Controller::Screen;

use Moose;

# if using 'extends', need to run at compile time to load attribute handlers
# from parent class otherwise StartRunmode, Runmode, etc fails - hack around AutoRunmode
BEGIN { extends 'LIMS::Base'; }
with (
	'LIMS::Controller::Roles::DataMap',
	'LIMS::Controller::Roles::RecordHandler',
);

# in .t: Not inlining a constructor for LIMS::Controller::Screen since it is
# not inheriting the default Moose::Object constructor - or if want to use the
# constructor from the non moose parent class:
__PACKAGE__->meta->make_immutable(inline_constructor => 0);

# ------------------------------------------------------------------------------
# default() should never be called direct - redirect to start page:
sub default : StartRunmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    return $self->redirect( $self->query->url );
}

# ------------------------------------------------------------------------------
sub load : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    my $errs = shift;

	return $self->forbidden() unless $self->user_can('screen');

    my $id = $self->param('id')
    || return $self->error('no id passed to ' . $self->get_current_runmode);

    # shouldn't exist in request_initial_screen table:
    if ( my $initial_screen = $self->model('Screen')->get_initial_screen($id) ) { 
		my $request_history_map = $self->request_history_map($id);
		
        $self->tt_params(
			initial_screen  => $initial_screen,
			request_history => $request_history_map,
		);
        return $self->tt_process('screen/already_screened.tt');
    }

    $self->js_validation_profile('initial_screen');

    # load initial_screen data into tt_params:
    $self->_load_initial_screen_data($id);

    return $self->render_view('screen/load_data.tt', $errs);
}

# ------------------------------------------------------------------------------
sub do_initial_screen : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    my $id = $self->param('id')
    || return $self->error('no id passed to ' . $self->get_current_runmode);

	# attempt to re-screen request (eg back button re-submit) is an error:	
    if ( my $initial_screen = $self->model('Screen')->get_initial_screen($id) ) {
		my $request_history_map = $self->request_history_map($id);

	    $self->tt_params(
            initial_screen  => $initial_screen,
            request_history => $request_history_map,
        );

        return $self->tt_process('screen/already_screened.tt');
    }

	my $dfv = $self->check_rm('load', $self->validate('initial_screen') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid; # $self->debug($data);
    $data->{_request_id} = $id;

	# get (optional) config file for auto_reportable requests:
	if ( my $cfg = $self->get_yaml_file('auto_reportable') ) {
		$data->{auto_reportable_config} = $cfg;
	}

    my $rtn = $self->model('Screen')->do_initial_screen($data);

    return $rtn ?
        $self->error($rtn) :
            $self->redirect( $self->query->url . '/search/=/' . $id );
}

# ------------------------------------------------------------------------------
sub edit : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    my $id = $self->param('id')
    || return $self->error('no id passed to ' . $self->get_current_runmode);
	
	return $self->forbidden() unless $self->user_can('screen');
	
	# attempt to load record before it's been screened is an error:
	my $initial_screen = $self->model('Screen')->get_initial_screen($id)
	|| return $self->error('cannot edit initial screen before record has been screened');
	
    my $screen_terms =
        $self->model('Screen')->get_all_screens({sort_by => 'description'});
	
    $self->tt_params(
		screen_terms   => $screen_terms,
		initial_screen => $initial_screen,
	);
	
	return $self->tt_process();
}

# ------------------------------------------------------------------------------
sub update : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    my $request_id = $self->param('id')
    || return $self->error('no id passed to ' . $self->get_current_runmode);
	
	return $self->forbidden() unless $self->user_can('screen');
	
	my $dfv = $self->check_rm('load', { required => 'screen_id' }  )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid; # $self->debug($data);
    $data->{request_id} = $request_id;

    my $rtn = $self->model('Screen')->update_screen($data);

    return $rtn ?
        $self->error($rtn) :
            $self->redirect( $self->query->url . '/search/=/' . $request_id );
}


# ------------------------------------------------------------------------------
sub _load_initial_screen_data {
    my $self = shift; $self->_debug_path();
    my $id   = shift;

    # get hashref of request data & specimen map:
    my $request_data = $self->get_single_request_data($id); # $self->debug($request_data);
    # deref into list of pairs for tt_params:
    $self->tt_params($_ => $request_data->{$_}) for keys %$request_data;

    { # get list of screens table data:
		my $screen_terms =
			$self->model('Screen')->get_all_screens({sort_by => 'description'});
		$self->tt_params( screen_terms => $screen_terms );
	}
	{ # request audit data:
		my $audit_data =
			$self->model('RequestAudit')->get_audit_options({sort_by => 'description'});
		$self->tt_params( request_audit => $audit_data );
	}
	{ # audit categories:
		my $categories =
			$self->model('RequestAudit')->get_audit_categories({sort_by => 'id'});
		$self->tt_params( categories => $categories );
	}	
	{ # previous patient matches:
		my $previous_cases = $self->get_previous_cases($request_data);
		$self->tt_params( previous_cases => $previous_cases );
	}
}

1;
