package LIMS::Controller::Local::Worklist::Preregistration; # only ucfirst or need an entry in Dispatch

use base 'LIMS::Base';

# ------------------------------------------------------------------------------
sub edit : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
	my $errs = shift; # $self->stash( errs => $errs );

	# capture labno:
	my $labno = $self->param('id')
	|| return $self->error( "no 'id' passed to " . $self->get_current_runmode );
	
    $self->js_validation_profile('pre_screen_data');

	my $tmpl = 'worklist/local/preregistration/'.$self->get_current_runmode.'.tt';
	return $self->tt_process($tmpl, $errs);	
}

# ------------------------------------------------------------------------------
sub update : Runmode {
	my $self = shift; $self->_debug_path($self->get_current_runmode);

	# capture labno:
	my $labno = $self->param('id')
	|| return $self->error( "no 'id' passed to " . $self->get_current_runmode );

    my $dfv = $self->check_rm( 'pre_screen_data', $self->validate('pre_screen_data') )
    || return $self->dfv_error_page;
	
	my $data = $dfv->valid;
	$data->{labno} = $labno; # add labno from param('id')
	
	my $rtn = $self->model('Local')->update_pre_registration_data($data);

	if ($rtn) {
		return $self->error($rtn);
	}
	else {
		$self->flash( info => $self->messages('action')->{edit_success} );
		return $self->redirect( $self->query->url
			. '/local_worklist?function_name=pre_screen' );
	}
}

# ------------------------------------------------------------------------------
sub specimen_edit : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
	my $errs = shift; # $self->stash( errs => $errs );
	
	# capture pre_registration_specimen.id:
	my $id = $self->param('id')
	|| return $self->error( "no 'id' passed to " . $self->get_current_runmode );
	
	# request_specimen data:
	my $rs_data = $self->model('Local')->get_unregistered_request_specimen($id);
	$self->tt_params( request_specimen => $rs_data ); # warn Dumper $data->as_tree;
	
	{ # prereg_lab_test data map:
		my $data_map 
			= $self->model('Local')->get_unregistered_request_lab_tests($id);
		# only 1 dataset in $data_map (only supplied 1 id), so extract it here: 
		$self->tt_params( lab_tests => $data_map->{$id} ); # warn Dumper $data;
	}
	{ # get list of specimens already in use for this pre_registration.id:
		my $data
			= $self->model('Local')->get_prereg_specimens($rs_data->pre_reg->id);
		my %map = map {	$_->specimen_code => 1 }
			# skip specimen type of existing request_specimen entry:
			grep { $_->specimen_code ne $rs_data->specimen_code} @$data;
		$self->tt_params( specimens_map => \%map ); # warn Dumper \%map;		
	}
	{ # lab-section id for tmpl hidden field:
		my $lab_section
			= $self->model('LabSection')->get_lab_section_by_name('Flow screen');
		$self->tt_params( lab_section_id => $lab_section->id );
	}
	
    $self->js_validation_profile('pre_screen_data');

	my $tmpl = 'worklist/local/preregistration/'.$self->get_current_runmode.'.tt';
	return $self->tt_process($tmpl, $errs);
}

# ------------------------------------------------------------------------------
sub specimen_update : Runmode {
	my $self = shift; $self->_debug_path($self->get_current_runmode);
	
	# capture pre_registration_specimen.id:
	my $id = $self->param('id')
	|| return $self->error( "no 'id' passed to " . $self->get_current_runmode );
	
    my $dfv = $self->check_rm( 'pre_screen_data', $self->validate('pre_screen_data') )
    || return $self->dfv_error_page;
	
	my $data = $dfv->valid;
	$data->{id} = $id; # warn Dumper $data;
	
	my $rtn = $self->model('Local')->update_pre_registration_specimen_data($data);

	if ($rtn) {
		return $self->error($rtn);
	}
	else {
		$self->flash( info => $self->messages('action')->{edit_success} );
		return $self->redirect( $self->query->url
			. '/local_worklist?function_name=pre_screen' );
	}
}

# ------------------------------------------------------------------------------
sub add_new : Runmode {
	my $self = shift; $self->_debug_path($self->get_current_runmode);
	my $errs = shift; # $self->stash( errs => $errs );
	
	# capture pre_registration.id:
	my $id = $self->param('id')
	|| return $self->error( "no 'id' passed to " . $self->get_current_runmode );
	
	{ # get data for pre_registration.id:
		my $data = $self->model('Local')->get_unregistered_request($id);
		$self->tt_params( prereg_data => $data ); # warn Dumper $data->as_tree;
	}
	{ # get list of specimens already in use for this pre_registration.id:
		my $data = $self->model('Local')->get_prereg_specimens($id);
		my %map = map {	$_->specimen_code => 1 } @$data;
		$self->tt_params( specimens_map => \%map ); # warn Dumper \%map;		
	}
	{ # lab-section id for tmpl hidden field:
		my $lab_section
			= $self->model('LabSection')->get_lab_section_by_name('Flow screen');
		$self->tt_params( lab_section_id => $lab_section->id );
	}
	
    $self->js_validation_profile('pre_screen_new');

	my $tmpl = 'worklist/local/preregistration/'.$self->get_current_runmode.'.tt';
	return $self->tt_process($tmpl, $errs);
}

# ------------------------------------------------------------------------------
sub new_data : Runmode {
	my $self = shift; $self->_debug_path($self->get_current_runmode);
	
	# capture pre_registration.id:
	my $id = $self->param('id')
	|| return $self->error( "no 'id' passed to " . $self->get_current_runmode );


    my $dfv = $self->check_rm( 'pre_screen_add_new', $self->validate('pre_screen_new') )
    || return $self->dfv_error_page;
	
	my $data = $dfv->valid;
	$data->{id} = $id; # warn Dumper $data;
	
	my $rtn = $self->model('Local')->new_pre_registration_data($data);

	if ($rtn) {
		return $self->error($rtn);
	}
	else {
		$self->flash( info => $self->messages('action')->{create_success} );
		return $self->redirect( $self->query->url
			. '/local_worklist?function_name=pre_screen' );
	}
}

1;