package LIMS::DB::Outreach::LabParam;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    schema  => 'outreach',
    
    table   => 'lab_params',
    
    columns => [
        id             => { type => 'serial', not_null => 1 },
        param_name     => { type => 'varchar', length => 255, not_null => 1 },
        field_label    => { type => 'varchar', length => 255, not_null => 1 },
        field_type     => { type => 'enum', check_in => [ 'menu', 'int', 'decimal' ],
            default => 'int', not_null => 1 },
        department_id  => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    foreign_keys => [
        department => {
            class       => 'LIMS::DB::Outreach::ResultType',
            key_columns => { department_id => 'id' },
        },
    ],

    relationships => [
        defaults_and_ranges => {
            class                => 'LIMS::DB::Outreach::DefaultAndRange',
            column_map           => { id => 'param_id' },
            type                 => 'one to one',
            with_column_triggers => '0',
        },
    ],
);
#=cut

__PACKAGE__->meta->make_manager_class('lab_params');

1;
