package LIMS::DB::LabSectionStatusOption;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'lab_section_status_option',

    columns => [
        lab_section_id   => { type => 'integer', default => '0', not_null => 1 },
        status_option_id => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'lab_section_id', 'status_option_id' ],

    foreign_keys => [
        lab_section => {
            class       => 'LIMS::DB::LabSection',
            key_columns => { lab_section_id => 'id' },
        },

        status_option => {
            class       => 'LIMS::DB::LabTestStatusOption',
            key_columns => { status_option_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('lab_section_status_option');

1;
