package LIMS::DB::DraftReportUser;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup (
    table   => 'draft_report_users',

    columns => [
        id               => { type => 'serial', not_null => 1 },
        username         => { type => 'varchar', length => 50, not_null => 1 },
        first_name       => { type => 'varchar', length => 50, not_null => 1 },
        last_name        => { type => 'varchar', length => 50, not_null => 1 },
        password         => { type => 'varchar', length => 32, not_null => 1 },
        email            => { type => 'varchar', length => 50, not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [
        [ 'email' ], [ 'username' ], [ qw(first_name last_name) ],
    ],

    relationships => [
        request_draft_report => {
            class      => 'LIMS::DB::RequestDraftReport',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },
    ],
);

# or to see what it should be:
#__PACKAGE__->meta->table('trials');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 2, braces => 'bsd');

__PACKAGE__->meta->make_manager_class('draft_report_users');

1;
