package LIMS::DB::Outreach::PatientBloodTube;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    schema  => 'outreach',

    table   => 'patient_blood_tube',

    columns => [
        patient_id => { type => 'integer', not_null => 1 },
        tube_type  => { type => 'enum', check_in => [ 'vacutainer', 'monovette' ] },
    ],

    primary_key_columns => [ 'patient_id' ],

    foreign_keys => [
        patient => {
            class       => 'LIMS::DB::Patient',
            key_columns => { patient_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('patient_blood_tubes');

1;