# generated automatically by script/make_classes.pl

#---------------------------------------------------------------------------
package LIMS::AdditionalOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'additional_options',

    columns => [
        id           => { type => 'integer', not_null => 1 },
        option_name  => { type => 'varchar', length => 255 },
        option_label => { type => 'varchar', length => 255 },
        is_active    => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [
        [ 'option_label' ],
        [ 'option_name' ],
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::AuditRequestCategory;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'audit_request_categories',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        description => { type => 'varchar', default => '', length => 255, not_null => 1 },
        active      => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::AuditRequestOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'audit_request_options',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        description => { type => 'varchar', default => '', length => 255, not_null => 1 },
        category_id => { type => 'integer', default => '0', not_null => 1 },
        active      => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ClinicalTrial;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'clinical_trials',

    columns => [
        id         => { type => 'integer', not_null => 1 },
        trial_name => { type => 'varchar', length => 50 },
        active     => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'trial_name' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ConsentOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'consent_options',

    columns => [
        id            => { type => 'integer', not_null => 1 },
        consent_name  => { type => 'varchar', default => '', length => 255, not_null => 1 },
        consent_label => { type => 'varchar', default => '', length => 255, not_null => 1 },
        is_active     => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [
        [ 'consent_label' ],
        [ 'consent_name' ],
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ContextWarningDiagnosi;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'context_warning_diagnosis',

    columns => [
        id                 => { type => 'integer', not_null => 1 },
        diagnosis_id       => { type => 'integer', default => '0', not_null => 1 },
        context_warning_id => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'diagnosis_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::DeletedRequest;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'deleted_requests',

    columns => [
        id             => { type => 'serial', not_null => 1 },
        request_id     => { type => 'integer', default => '0', not_null => 1 },
        request_number => { type => 'integer', default => '0', not_null => 1 },
        year           => { type => 'scalar', default => '0000', length => 4, not_null => 1 },
        action         => { type => 'varchar', default => '', length => 255, not_null => 1 },
        user_id        => { type => 'integer', default => '0', not_null => 1 },
        time           => { type => 'datetime' },
    ],

    primary_key_columns => [ 'id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::Diagnos;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'diagnoses',

    columns => [
        id                     => { type => 'integer', not_null => 1 },
        name                   => { type => 'varchar', length => 255 },
        icdo3                  => { type => 'varchar', length => 6 },
        diagnostic_category_id => { type => 'integer' },
        active                 => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes' },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'name' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::DiagnosisChangeOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'diagnosis_change_options',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        option_name => { type => 'varchar', default => '', length => 25, not_null => 1 },
        description => { type => 'varchar', default => '', length => 255, not_null => 1 },
        is_active   => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'option_name' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::DiagnosisContextWarning;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'diagnosis_context_warnings',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        description => { type => 'varchar', default => '', length => 255, not_null => 1 },
        is_active   => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes' },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::DiagnosticCategory;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'diagnostic_categories',

    columns => [
        id            => { type => 'integer', not_null => 1 },
        description   => { type => 'varchar', length => 255 },
        category_type => { type => 'enum', check_in => [ 'main', 'sub' ] },
        active        => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes' },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::EmailAddress;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'email_addresses',

    columns => [
        address => { type => 'varchar', length => 255, not_null => 1 },
    ],

    primary_key_columns => [ 'address' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::EmailContact;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'email_contacts',

    columns => [
        id                 => { type => 'integer', not_null => 1 },
        display_name       => { type => 'varchar', default => '', length => 255, not_null => 1 },
        scope              => { type => 'enum', check_in => [ 'hospital', 'organisation' ] },
        referral_source_id => { type => 'integer', default => '0', not_null => 1 },
        type               => { type => 'enum', check_in => [ 'mdt', 'report', 'other' ] },
        contact_address    => { type => 'varchar', default => '', length => 255, not_null => 1 },
        is_active          => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'type', 'contact_address' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ErrorCode;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'error_codes',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        code        => { type => 'varchar', length => 2 },
        description => { type => 'varchar', length => 255 },
        is_unique   => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
        active      => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'code' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::HospitalDepartment;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'hospital_departments',

    columns => [
        id           => { type => 'integer', not_null => 1 },
        display_name => { type => 'varchar', default => '', length => 50, not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'display_name' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::IcdoCategory;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'icdo_category',

    columns => [
        diagnostic_category_id => { type => 'integer', not_null => 1 },
        icdo3                  => { type => 'varchar', length => 6, not_null => 1 },
    ],

    primary_key_columns => [ 'diagnostic_category_id', 'icdo3' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::LabSection;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'lab_sections',

    columns => [
        id                 => { type => 'integer', not_null => 1 },
        section_name       => { type => 'varchar', default => '', length => 255, not_null => 1 },
        has_result_summary => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'no', not_null => 1 },
        has_section_notes  => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'no', not_null => 1 },
        has_test_sign_out  => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'no', not_null => 1 },
        has_foreign_id     => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'no', not_null => 1 },
        has_results_import => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'no', not_null => 1 },
        is_active          => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'section_name' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::LabSectionStatusOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'lab_section_status_option',

    columns => [
        lab_section_id   => { type => 'integer', not_null => 1 },
        status_option_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'lab_section_id', 'status_option_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::LabTest;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'lab_tests',

    columns => [
        id             => { type => 'integer', not_null => 1 },
        test_name      => { type => 'varchar', default => '', length => 25, not_null => 1 },
        field_label    => { type => 'varchar', default => '', length => 25, not_null => 1 },
        lab_section_id => { type => 'integer', default => '0', not_null => 1 },
        test_type      => { type => 'enum', check_in => [ 'test', 'panel' ] },
        has_results    => { type => 'enum', check_in => [ 'yes', 'no' ] },
        is_active      => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [
        [ 'lab_section_id', 'test_type', 'field_label' ],
        [ 'lab_section_id', 'test_type', 'test_name' ],
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::LabTestDataType;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'lab_test_data_type',

    columns => [
        lab_test_id  => { type => 'integer', not_null => 1 },
        data_type_id => { type => 'integer', default => '0', not_null => 1 },
        is_active    => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'lab_test_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::LabTestMap;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => '_lab_test_map',

    columns => [
        id       => { type => 'integer', not_null => 1 },
        TestName => { type => 'varchar', length => 255 },
    ],

    primary_key_columns => [ 'id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::LabTestResultDataType;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'lab_test_result_data_types',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        description => { type => 'varchar', default => '', length => 25, not_null => 1 },
        is_active   => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::LabTestResultOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'lab_test_result_options',

    columns => [
        id           => { type => 'integer', not_null => 1 },
        data_type_id => { type => 'integer', default => '0', not_null => 1 },
        value        => { type => 'varchar', default => '', length => 30, not_null => 1 },
        is_active    => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'data_type_id', 'value' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::LabTestStatusOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'lab_test_status_options',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        description => { type => 'varchar', default => '', length => 255, not_null => 1 },
        is_editable => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
        is_active   => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::LocalNetworkLocation;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'local_network_locations',

    columns => [
        parent_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'parent_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::Login;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'logins',

    columns => [
        id         => { type => 'serial', not_null => 1 },
        user_id    => { type => 'integer', default => '0', not_null => 1 },
        address    => { type => 'varchar', length => 15 },
        browser    => { type => 'varchar', length => 255 },
        session_id => { type => 'character', length => 32 },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ParentOrganisation;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'parent_organisations',

    columns => [
        id               => { type => 'integer', not_null => 1 },
        parent_code      => { type => 'varchar', default => '', length => 6, not_null => 1 },
        description      => { type => 'varchar', default => '', length => 255, not_null => 1 },
        referral_type_id => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [
        [ 'description' ],
        [ 'parent_code' ],
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::Patient;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'patients',

    columns => [
        id          => { type => 'serial', not_null => 1 },
        last_name   => { type => 'varchar', length => 50 },
        first_name  => { type => 'varchar', length => 50 },
        middle_name => { type => 'varchar', length => 50 },
        dob         => { type => 'date' },
        gender      => { type => 'enum', check_in => [ 'M', 'F', 'U' ], default => 'U' },
        nhs_number  => { type => 'varchar', length => 10 },
        created_at  => { type => 'timestamp', not_null => 1 },
        updated_at  => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'nhs_number' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PatientCase;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'patient_case',

    columns => [
        id                 => { type => 'serial', not_null => 1 },
        patient_id         => { type => 'integer', default => '0', not_null => 1 },
        referral_source_id => { type => 'integer', default => '0', not_null => 1 },
        unit_number        => { type => 'varchar', default => 'UNKNOWN', length => 255, not_null => 1 },
        time               => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'patient_id', 'unit_number', 'referral_source_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PatientDemographic;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'patient_demographics',

    columns => [
        patient_id     => { type => 'integer', not_null => 1 },
        address        => { type => 'varchar', length => 255 },
        post_code      => { type => 'varchar', length => 8 },
        contact_number => { type => 'varchar', length => 15 },
        gp_id          => { type => 'integer', default => '0', not_null => 1 },
        practice_id    => { type => 'integer', default => '0', not_null => 1 },
        status         => { type => 'enum', check_in => [ 'alive', 'dead' ], default => 'alive', not_null => 1 },
        dod            => { type => 'date' },
        time           => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'patient_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PatientDemographicHistory;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'patient_demographic_history',

    columns => [
        id         => { type => 'serial', not_null => 1 },
        patient_id => { type => 'integer', default => '0', not_null => 1 },
        user_id    => { type => 'integer', default => '0', not_null => 1 },
        action     => { type => 'varchar', default => '', length => 255, not_null => 1 },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PatientEdit;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'patient_edits',

    columns => [
        id            => { type => 'serial', not_null => 1 },
        patient_id    => { type => 'integer', default => '0', not_null => 1 },
        last_name     => { type => 'varchar', length => 50 },
        first_name    => { type => 'varchar', length => 50 },
        middle_name   => { type => 'varchar', length => 50 },
        dob           => { type => 'date' },
        gender        => { type => 'enum', check_in => [ 'M', 'F', 'U' ], default => 'U' },
        nhs_number    => { type => 'varchar', length => 10 },
        user_id       => { type => 'integer', default => '', not_null => 1 },
        error_code_id => { type => 'integer', default => '', not_null => 1 },
        time          => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PatientTrial;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'patient_trial',

    columns => [
        patient_id   => { type => 'integer', not_null => 1 },
        trial_id     => { type => 'integer', not_null => 1 },
        trial_number => { type => 'varchar', length => 255 },
    ],

    primary_key_columns => [ 'patient_id', 'trial_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PhoneLogOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'phone_log_options',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        description => { type => 'varchar', default => '', length => 255, not_null => 1 },
        is_active   => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PreRegistration;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'pre_registration',

    columns => [
        id          => { type => 'serial', not_null => 1 },
        labno       => { type => 'varchar', default => '', length => 8, not_null => 1 },
        surname     => { type => 'varchar', length => 25 },
        is_screened => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'no', not_null => 1 },
        time        => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'labno' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PreRegistrationLabTest;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'pre_registration_lab_test',

    columns => [
        id              => { type => 'serial', not_null => 1 },
        reg_specimen_id => { type => 'integer', default => '0', not_null => 1 },
        lab_test_id     => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'reg_specimen_id', 'lab_test_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PreRegistrationSpecimen;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'pre_registration_specimen',

    columns => [
        id            => { type => 'serial', not_null => 1 },
        pre_reg_id    => { type => 'integer', default => '0', not_null => 1 },
        specimen_code => { type => 'character', default => '0', length => 2, not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'pre_reg_id', 'specimen_code' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::QuestionnaireSymptom;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'questionnaire_symptoms',

    columns => [
        request_id              => { type => 'integer', not_null => 1 },
        weight                  => { type => 'float', precision => 32 },
        weight_loss             => { type => 'enum', check_in => [ 'Y', 'N' ] },
        night_sweats            => { type => 'enum', check_in => [ 'none', 'occasional', 'frequent', 'drenching' ] },
        persistent_night_sweats => { type => 'enum', check_in => [ 'Y', 'N' ] },
        serious_infection       => { type => 'enum', check_in => [ 'Y', 'N' ] },
    ],

    primary_key_columns => [ 'request_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ReferralSource;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'referral_sources',

    columns => [
        id                     => { type => 'integer', not_null => 1 },
        display_name           => { type => 'varchar', default => '', length => 255, not_null => 1 },
        organisation_code      => { type => 'varchar', default => '', length => 6, not_null => 1 },
        parent_organisation_id => { type => 'integer', default => '0', not_null => 1 },
        referral_type_id       => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [
        [ 'display_name' ],
        [ 'organisation_code' ],
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ReferralType;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'referral_types',

    columns => [
        id              => { type => 'integer', not_null => 1 },
        description     => { type => 'varchar', default => '', length => 255, not_null => 1 },
        prefix          => { type => 'varchar', length => 2 },
        default_unknown => { type => 'varchar', default => '', length => 8, not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::Referrer;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'referrers',

    columns => [
        id               => { type => 'serial', not_null => 1 },
        name             => { type => 'varchar', default => '', length => 255, not_null => 1 },
        national_code    => { type => 'varchar', default => '', length => 8, not_null => 1 },
        referral_type_id => { type => 'integer', default => '0', not_null => 1 },
        active           => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'national_code' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ReferrerDepartment;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'referrer_department',

    columns => [
        id                       => { type => 'serial', not_null => 1 },
        referrer_id              => { type => 'integer', default => '0', not_null => 1 },
        parent_organisation_id   => { type => 'integer', default => '0', not_null => 1 },
        hospital_department_code => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'referrer_id', 'parent_organisation_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ReportErrorCode;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'report_error_codes',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        code        => { type => 'varchar', length => 2 },
        description => { type => 'varchar', length => 255 },
        active      => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'code' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::Request;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'requests',

    columns => [
        id                     => { type => 'serial', not_null => 1 },
        request_number         => { type => 'integer', default => '0', not_null => 1 },
        year                   => { type => 'scalar', default => '0000', length => 4, not_null => 1 },
        patient_case_id        => { type => 'integer', default => '0', not_null => 1 },
        referrer_department_id => { type => 'integer', default => '0', not_null => 1 },
        status_option_id       => { type => 'integer', default => 1, not_null => 1 },
        created_at             => { type => 'timestamp', not_null => 1 },
        updated_at             => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'request_number', 'year' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestAudit;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_audit',

    columns => [
        request_id              => { type => 'integer', not_null => 1 },
        audit_request_option_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'audit_request_option_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestAuthorisationDiagnosi;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_authorisation_diagnosis',

    columns => [
        request_id          => { type => 'integer', not_null => 1 },
        report_diagnosis_id => { type => 'integer', default => '0', not_null => 1 },
        auth_diagnosis_id   => { type => 'integer', default => '0', not_null => 1 },
        user_id             => { type => 'integer', default => '0', not_null => 1 },
        time                => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestConsent;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_consent',

    columns => [
        request_id => { type => 'integer', not_null => 1 },
        consent_id => { type => 'integer', not_null => 1 },
        status     => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'no', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'consent_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestDiagnosisHistory;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_diagnosis_history',

    columns => [
        id           => { type => 'serial', not_null => 1 },
        request_id   => { type => 'integer', default => '', not_null => 1 },
        diagnosis_id => { type => 'integer', default => '', not_null => 1 },
        reason       => { type => 'enum', check_in => [ 'error', 'update' ] },
        user_id      => { type => 'integer', default => '', not_null => 1 },
        time         => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestDispatchLog;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_dispatch_log',

    columns => [
        id         => { type => 'serial', not_null => 1 },
        request_id => { type => 'integer', default => '0', not_null => 1 },
        recipient  => { type => 'varchar', default => '', length => 255, not_null => 1 },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestErrorCode;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_error_code',

    columns => [
        id            => { type => 'serial', not_null => 1 },
        request_id    => { type => 'integer', default => '0', not_null => 1 },
        error_code_id => { type => 'integer', default => '0', not_null => 1 },
        user_id       => { type => 'integer', default => '0', not_null => 1 },
        time          => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestExternalRef;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_external_ref',

    columns => [
        request_id         => { type => 'integer', not_null => 1 },
        external_reference => { type => 'varchar', default => '', length => 255, not_null => 1 },
        status             => { type => 'varchar', length => 255 },
    ],

    primary_key_columns => [ 'request_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestGeneralNote;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_general_notes',

    columns => [
        request_id => { type => 'integer', not_null => 1 },
        detail     => { type => 'text', length => 65535 },
    ],

    primary_key_columns => [ 'request_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestGrossDescription;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_gross_description',

    columns => [
        request_id => { type => 'integer', not_null => 1 },
        detail     => { type => 'text', length => 65535 },
    ],

    primary_key_columns => [ 'request_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestHistory;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_history',

    columns => [
        id         => { type => 'serial', not_null => 1 },
        request_id => { type => 'integer', default => '0', not_null => 1 },
        action     => { type => 'varchar', default => '', length => 255, not_null => 1 },
        user_id    => { type => 'integer', default => '0', not_null => 1 },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestInitialScreen;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_initial_screen',

    columns => [
        request_id => { type => 'integer', not_null => 1 },
        screen_id  => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestLabSectionForeignId;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_lab_section_foreign_id',

    columns => [
        request_id     => { type => 'integer', not_null => 1 },
        lab_section_id => { type => 'integer', not_null => 1 },
        foreign_id     => { type => 'varchar', default => '', length => 25, not_null => 1 },
        time           => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'lab_section_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestLabSectionNote;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_lab_section_notes',

    columns => [
        request_id     => { type => 'integer', not_null => 1 },
        lab_section_id => { type => 'integer', not_null => 1 },
        details        => { type => 'text', length => 65535 },
        time           => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'lab_section_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestLabTestHistory;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_lab_test_history',

    columns => [
        id         => { type => 'serial', not_null => 1 },
        request_id => { type => 'integer', default => '0', not_null => 1 },
        action     => { type => 'varchar', default => '', length => 255, not_null => 1 },
        user_id    => { type => 'integer', default => '0', not_null => 1 },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestLabTestResult;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_lab_test_results',

    columns => [
        id          => { type => 'serial', not_null => 1 },
        request_id  => { type => 'integer', default => '0', not_null => 1 },
        lab_test_id => { type => 'integer', default => '0', not_null => 1 },
        result      => { type => 'varchar', default => '', length => 255, not_null => 1 },
        time        => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'request_id', 'lab_test_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestLabTestStatu;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_lab_test_status',

    columns => [
        id               => { type => 'serial', not_null => 1 },
        request_id       => { type => 'integer', default => '0', not_null => 1 },
        lab_test_id      => { type => 'integer', default => '0', not_null => 1 },
        status_option_id => { type => 'integer', default => '0', not_null => 1 },
        user_id          => { type => 'integer', default => '0', not_null => 1 },
        time             => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'request_id', 'lab_test_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_option',

    columns => [
        request_id => { type => 'integer', not_null => 1 },
        option_id  => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'option_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestPhoneLog;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_phone_log',

    columns => [
        id         => { type => 'serial', not_null => 1 },
        request_id => { type => 'integer', default => '0', not_null => 1 },
        user_id    => { type => 'integer', default => '0', not_null => 1 },
        status     => { type => 'enum', check_in => [ 'inbound', 'outbound' ] },
        contact    => { type => 'varchar', default => '', length => 255, not_null => 1 },
        details    => { type => 'varchar', default => '', length => 255, not_null => 1 },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestPrintLog;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_print_log',

    columns => [
        id         => { type => 'serial', not_null => 1 },
        request_id => { type => 'integer', default => '0', not_null => 1 },
        user_id    => { type => 'integer', default => '0', not_null => 1 },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestReport;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_report',

    columns => [
        request_id       => { type => 'integer', not_null => 1 },
        comment          => { type => 'text', length => 65535 },
        clinical_details => { type => 'text', length => 65535 },
        status           => { type => 'enum', check_in => [ 'new', 'relapse', 'default' ], default => 'default', not_null => 1 },
        specimen_quality => { type => 'enum', check_in => [ 'good', 'adequate', 'poor' ], default => 'adequate', not_null => 1 },
        diagnosis_id     => { type => 'integer', default => '', not_null => 1 },
        created_at       => { type => 'timestamp', not_null => 1 },
        updated_at       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestReportHistory;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_report_history',

    columns => [
        id         => { type => 'serial', not_null => 1 },
        request_id => { type => 'integer', default => '0', not_null => 1 },
        field      => { type => 'varchar', default => '', length => 255, not_null => 1 },
        content    => { type => 'text', length => 65535 },
        user_id    => { type => 'integer', default => '0', not_null => 1 },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestResultSummary;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_result_summaries',

    columns => [
        request_id      => { type => 'integer', not_null => 1 },
        lab_section_id  => { type => 'integer', not_null => 1 },
        results_summary => { type => 'text', length => 65535 },
        time            => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'lab_section_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestSpecimen;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_specimen',

    columns => [
        request_id  => { type => 'integer', not_null => 1 },
        specimen_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'specimen_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestTrial;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_trial',

    columns => [
        request_id => { type => 'integer', not_null => 1 },
        trial_id   => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestViewLog;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_view_log',

    columns => [
        id         => { type => 'serial', not_null => 1 },
        request_id => { type => 'integer', default => '0', not_null => 1 },
        user_id    => { type => 'integer', default => '0', not_null => 1 },
        ip_address => { type => 'varchar', default => '', length => 255, not_null => 1 },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ResultSummaryOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'result_summary_options',

    columns => [
        id             => { type => 'integer', not_null => 1 },
        description    => { type => 'varchar', default => '', length => 255, not_null => 1 },
        lab_section_id => { type => 'integer', default => '0', not_null => 1 },
        is_active      => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description', 'lab_section_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::Screen;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'screens',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        description => { type => 'varchar', length => 50 },
        sample_type => { type => 'enum', check_in => [ 'fresh', 'fixed' ] },
        active      => { type => 'enum', check_in => [ 'yes', 'no' ] },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ScreenLabTest;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'screen_lab_test',

    columns => [
        screen_id   => { type => 'integer', not_null => 1 },
        lab_test_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'screen_id', 'lab_test_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ScreenLabTestDetail;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'screen_lab_test_detail',

    columns => [
        screen_id      => { type => 'integer', not_null => 1 },
        lab_section_id => { type => 'integer', not_null => 1 },
        test_details   => { type => 'varchar', default => '', length => 255, not_null => 1 },
    ],

    primary_key_columns => [ 'screen_id', 'lab_section_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::Specimen;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'specimens',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        sample_code => { type => 'varchar', length => 4 },
        description => { type => 'varchar', length => 40 },
        active      => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'sample_code' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::SpecimenLabTest;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'specimen_lab_test',

    columns => [
        specimen_id => { type => 'integer', not_null => 1 },
        lab_test_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'specimen_id', 'lab_test_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::StatusOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'status_options',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        description => { type => 'varchar', default => '', length => 255, not_null => 1 },
        is_editable => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
        is_active   => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::User;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'users',

    columns => [
        id               => { type => 'integer', not_null => 1 },
        username         => { type => 'varchar', default => 'username', length => 50, not_null => 1 },
        first_name       => { type => 'varchar', default => 'first_name', length => 50, not_null => 1 },
        last_name        => { type => 'varchar', default => 'last_name', length => 50, not_null => 1 },
        password         => { type => 'varchar', default => 'password', length => 32, not_null => 1 },
        email            => { type => 'varchar', default => 'user@here.com', length => 50, not_null => 1 },
        user_location_id => { type => 'integer', default => '0', not_null => 1 },
        designation      => { type => 'varchar', default => 'designation', length => 50, not_null => 1 },
        group_id         => { type => 'integer', default => '0', not_null => 1 },
        last_login       => { type => 'timestamp', not_null => 1 },
        active           => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [
        [ 'email' ],
        [ 'first_name', 'last_name' ],
        [ 'username' ],
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::UserFunction;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'user_functions',

    columns => [
        id              => { type => 'integer', not_null => 1 },
        function_name   => { type => 'varchar', length => 20 },
        function_detail => { type => 'varchar', length => 255 },
        active          => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [
        [ 'function_detail' ],
        [ 'function_name' ],
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::UserGroup;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'user_groups',

    columns => [
        id           => { type => 'integer', not_null => 1 },
        group_name   => { type => 'varchar', length => 10 },
        group_label  => { type => 'varchar', length => 30 },
        group_detail => { type => 'varchar', length => 255 },
        active       => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [
        [ 'group_label' ],
        [ 'group_name' ],
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::UserGroupFunction;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'user_group_function',

    columns => [
        group_id    => { type => 'integer', not_null => 1 },
        function_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'group_id', 'function_id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::UserLocation;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'user_locations',

    columns => [
        id            => { type => 'integer', not_null => 1 },
        location_name => { type => 'varchar', default => '', length => 50, not_null => 1 },
        active        => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes' },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'location_name' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::UserPermission;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'user_permission',

    columns => [
        user_id     => { type => 'integer', not_null => 1 },
        function_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'user_id', 'function_id' ],
);

1;

