package LIMS::DB::RequestDiagnosisHistory;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'request_diagnosis_history',

    columns => [
        id           => { type => 'serial', not_null => 1 },
        request_id   => { type => 'integer', not_null => 1 },
        diagnosis_id => { type => 'integer', not_null => 1 },
        reason       => { type => 'enum', check_in => [ 'error', 'update' ] },
        user_id      => { type => 'integer', not_null => 1 },
        time         => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    foreign_keys => [
        diagnosis => {
            class       => 'LIMS::DB::Diagnosis',
            key_columns => { diagnosis_id => 'id' },
        },

        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
        },

        user => {
            class       => 'LIMS::DB::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('request_diagnosis_histories');

1;