package LIMS::DB::Outreach::QuestionnaireTreatment;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    schema  => 'outreach',
    
    table   => 'questionnaire_treatment',
    
    columns => [
        request_id        => { type => 'integer', not_null => 1 },
        hospital_referral => { type => 'enum', check_in => [ 'Y', 'N' ] },
        new_medication    => { type => 'enum', check_in => [ 'Y', 'N' ] },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);
#=cut

__PACKAGE__->meta->make_manager_class('questionnaire_treatments');

1;
