package LIMS::Controller::Admin::Lab::Test::DataTypes;

use base 'LIMS::Base';
use LIMS::Local::Sugar;

use Moose;
    with 'LIMS::Controller::Roles::DataMap';
__PACKAGE__->meta->make_immutable;

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

# -------------------------------------------------------------------------------------
startmode default ($errs) {
    $self->_debug_path($self->get_current_runmode);    

 	my $sort_by = $self->query->param('sort_by') || 'field_label';   

	my %args = (); 

	if ( my $lab_section_id = $self->query->param('lab_section_id') ) {
		$args{lab_section_id} = $lab_section_id;
	}

    my $total = $self->model('LabTest')->get_resultable_lab_tests_count(\%args);

	$args{sort_by} = $sort_by;

	if ( $total > $self->cfg('settings')->{entries_per_page} ) {
        # invoke pager for template and add limit & offset params to \%args:
        $self->pager({ query => \%args, total => $total });
    }

	{ # get list of lab_sections table data:
		my $sections = $self->model('LabSection')->get_lab_sections();
		$self->tt_params( sections => $sections );
	}
	{ # get lab_tests flagged as resultable:
		my $lab_tests = $self->model('LabTest')->get_resultable_lab_tests(\%args);
		$self->tt_params( lab_tests => $lab_tests );
	}
	{ # get data types:
		my $data_types = $self->model('Base')->get_objects('LabTestResultDataType');
		$self->tt_params( data_types => $data_types );
	}
	{ # get existing data type definitions:
		my $data_map = $self->lab_test_data_types_map;	
		$self->tt_params( data_map => $data_map );
	}
	
	return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
runmode edit ($errs, $id) {
	$self->_debug_path($self->get_current_runmode);
	
    $id || return $self->error('no id passed to '.$self->get_current_runmode);  

    { # lab_test data:
		my $lab_test = $self->model('LabTest')->get_lab_test_data_type($id);
		
		# convert lab_test object to hashref to prevent db query on empty object:
		my $data = $lab_test->as_tree;
		
		$self->tt_params( data => $data );
	}
	{ # get all lab test result data types:
		my $data_types = $self->model('Base')->get_objects('LabTestResultDataType');
		$self->tt_params( data_types => $data_types );
	}

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('lab_test_data_type');

    return $self->tt_process($errs);	
}

# -------------------------------------------------------------------------------------
runmode update ($id) {
    $self->_debug_path($self->get_current_runmode);
    
    $id || return $self->error('no id passed to '.$self->get_current_runmode);  

	my $dfv = $self->check_rm('edit', $self->validate('lab_test_data_type') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid
    || return $self->forward('default'); # eg if empty param

	$data->{lab_test_id} = $id;

    my $rtn = $self->model('LabTest')->update_lab_test_data_type($data);

	if ($rtn) {
		return $self->error($rtn);
	}
	else {
		$self->flash( info => $self->messages('action')->{edit_success} );
		return $self->redirect( $self->query->url . '/admin/lab_test_data-types' );
	}
}

1;