package LIMS::Controller::Admin::Lab::Section::StatusOptions;

use Moose;
BEGIN { extends 'LIMS::Base'; }
with 'LIMS::Controller::Roles::DataMap';
__PACKAGE__->meta->make_immutable(inline_constructor => 0);

use LIMS::Local::Sugar;

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

# ------------------------------------------------------------------------------
startmode default {
    $self->_debug_path($self->get_current_runmode);

    { # lab_section_status_options table data:
		my $section_options  = $self->all_lab_section_status_options_map;
		$self->tt_params( section_options => $section_options );
	}
	{ # lab-sections map:
		my $lab_sections_map = $self->lab_sections_map;
		$self->tt_params( lab_sections_map => $lab_sections_map );
	}
    
    return $self->tt_process;
}

# ------------------------------------------------------------------------------
runmode edit ($id) {
	$self->_debug_path($self->get_current_runmode);
	
	$id || return $self->error( 'no id passed to ' . $self->get_current_runmode );
	
	{ # lab_section_status_options map for this lab_section.id:
		my $data = $self->_lab_section_status_options_map($id);
		$self->tt_params( data => $data );
	}
	{ # all lab_test_status_options:
		my $status_options
			= $self->model('Base')->get_objects('LabTestStatusOption');
		$self->tt_params( status_options => $status_options );
	}
	{ # lab-sections map (need to 'invert' $self->lab_sections_map):
		my $lab_section = $self->model('LabSection')->get_lab_section($id);
		$self->tt_params( lab_section => $lab_section );
	}
	
    return $self->tt_process;
}

# ------------------------------------------------------------------------------
runmode update ($id) {
	$self->_debug_path($self->get_current_runmode);
	
	$id || return $self->error( 'no id passed to ' . $self->get_current_runmode );
	
    my $dfv = $self->check_rm('edit', $self->validate('section_status_options') );
    my $data = $dfv->valid; # only valid param = specimen_id
    
    $data->{section_id} = $id;
    
    my $rtn = $self->model('LabSection')->update_section_status_options($data);
    
    if ($rtn) {
        return $self->error($rtn);
    }
    else {
        $self->flash( info => $self->messages('action')->{edit_success});
        return $self->redirect( $self->query->url . '/admin/lab_section_status-options');
    }	
}

# ------------------------------------------------------------------------------
sub _lab_section_status_options_map {
	my ($self, $section_id) = @_;
	
	my $o = $self->model('LabSection')->get_section_status_options($section_id);
	
	my %map = map {
		$_->status_option_id => 1;
	} @$o;
	return \%map;
}

1;