package LIMS::Controller::Admin::Config::HmrnLocations;

use base 'LIMS::Base';

use LIMS::Local::Sugar;
use Data::Dumper;

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

#-------------------------------------------------------------------------------
startmode default { 
    $self->_debug_path($self->get_current_runmode);

    { # get existing HMRN parent orgs:
        my $locations = $self->model('Base')->get_objects('LocalNetworkLocation');
        my %map = map { $_->parent_id => 1 } @$locations;
        $self->tt_params( hmrn_location_map => \%map );
    }   
    
    { # get all parent orgs:
        my @args = (
            { 'referral_type.description' => 'hospital' },
            { sort_by => 'description' },
        );
        
        my $parent_orgs
            = $self->model('ReferralSource')->get_parent_organisations(@args);

        $self->tt_params( parent_orgs => $parent_orgs );
    }

    return $self->tt_process;
}

#-------------------------------------------------------------------------------
runmode update { 
    $self->_debug_path($self->get_current_runmode);
 
    my @parent_ids = $self->query->param('parent_id'); # warn Dumper \@parent_ids;
    
    my $rtn = $self->model('ReferralSource')->update_network_locations(\@parent_ids);
    
    return $rtn
        ? $self->error($rtn)
        : $self->redirect( $self->query->url . '/config/hmrn-locations' );
}

1;