package LIMS::DB::Screen;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'screens',

    columns => [
        id          => { type => 'serial', not_null => 1 },
        category_id => { type => 'int' },
        description => { type => 'varchar', length => 50 },
        active	    => { type => 'enum', check_in => [ 'yes', 'no' ], not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'category_id', 'description' ],

    foreign_keys => [
        category => {
            class       => 'LIMS::DB::ScreenCategory',
            key_columns => { category_id => 'id' },
        },
    ],
    
    relationships => [
        request_initial_screen => {
            class      => 'LIMS::DB::RequestInitialScreen',
            column_map => { id => 'screen_id' },
            type       => 'one to many',
        },

        screen_lab_test => {
            class      => 'LIMS::DB::ScreenLabTest',
            column_map => { id => 'screen_id' },
            type       => 'one to many',
        },

        screen_lab_test_detail => {
            class      => 'LIMS::DB::ScreenLabTestDetail',
            column_map => { id => 'screen_id' },
            type       => 'one to many',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('screens');

1;
