package LIMS::Model::Coding;

use Moose;
extends 'LIMS::Model::Base';
use namespace::clean -except => 'meta';
__PACKAGE__->meta->make_immutable;

#-------------------------------------------------------------------------------
sub get_anatomical_sites {
    my $self = shift;
    my $args = shift || {};
    LIMS::DB::AnatomicalSite::Manager->get_objects(%$args);
}

#-------------------------------------------------------------------------------
sub get_anatomical_site {
    my ($self, $site_id) = @_;

    my $o = LIMS::DB::AnatomicalSite->new( id => $site_id )->load;
    return $o;
}

#-------------------------------------------------------------------------------
sub update_anatomical_sites {
    my $self = shift;
    my $data = shift; # $self->debug( $data );

    my %args = ( class => 'AnatomicalSite', data  => $data );
    return $self->update_object(\%args);
}

1;
