package LIMS::DB::Referrer;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup (
    table   => 'referrers',

    columns => [
        id               => { type => 'serial', not_null => 1 },
        name             => { type => 'varchar', length => 255, not_null => 1 },
        national_code    => { type => 'varchar', length => 8, not_null => 1 },
        referral_type_id => { type => 'integer', default => '0', not_null => 1 },
        active           => { type => 'enum', check_in => [ 'yes', 'no' ],
                                default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'national_code' ],

    foreign_keys => [
        referral_type => {
            class       => 'LIMS::DB::ReferralType',
            key_columns => { referral_type_id => 'id' },
        },
    ],

    relationships => [
        referrer_department => {
            class      => 'LIMS::DB::ReferrerDepartment',
            column_map => { id => 'referrer_id' },
            type       => 'one to many',
        },
    ],
);

# or to see what it should be:
#__PACKAGE__->meta->table('clinicians');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 2, braces => 'bsd');

__PACKAGE__->meta->make_manager_class('referrers');

1;
