use List::Util;
use Net::Telnet;
use XML::LibXML;
use Modern::Perl;
use Data::Printer;
use Sort::Naturally;
use XML::Simple qw(:strict);
use Time::HiRes qw(gettimeofday tv_interval);

my ($host,$port) = split /:/,
#	'163.160.119.21:2001';  # genomics
#	'163.160.215.218:2001'; # hmds xtr-96
    '163.160.214.206:5900'; # hmds intellicode

my $t0 = [gettimeofday];

do_intellicode_method();
# do_buffer_method(); # works for both
# do_waitfor_method(); # only reliably works for xtr-96 using /H12,(.*)/
# do_cmd_method(); # doesn't work

say sprintf 'finished: %.2f sec', tv_interval $t0, [gettimeofday];

# works for both XTR-96 & Intellicode:
sub do_buffer_method { # original HILIS method - uses buffer():
    my @args = (
        Timeout	=> 15,
        Errmode	=> 'return', # don't die (default)
		Input_Log 	=> './xtr-96.log', # uncomment to debug
    );
    my $t = connect_and_get(@args);

	# direct manipulation of buffer easier than documented methods!!
	my $ref = $t->buffer; # p $ref;
    say $t->errmsg if $t->errmsg;
	$t->close;
	do_extract(${$ref}); # send deref'd string
    say "do_buffer_method for $host";
;
}

# works for both using /H12,(.*)/ for XTR-96, and using /(.*)/ for Intellicode sometimes!!:
sub do_waitfor_method { # new HILIS method - uses waitfor():
    my @args = (
        # Timeout	=> 15, done in waitfor() now otherwise processes delay until $secs
        Errmode	=> 'return', # don't die (default)
    	Input_Log 	=> './xtr-96.log', # uncomment to debug
    );
    my $t = connect_and_get(@args);

=begin # this works for both but on 96-well only (can't use less than H12 as it'll send as soon as /$re/):
    my $re = qr{H12,(.*)}; # end of output = H12,<result>
    my ($prematch, $match) = $t->waitfor(Match => "/$re/", Timeout => undef); # no timeout
    my $output = join '', $prematch, $match;
=cut
#=begin # this (sometimes!!) works for Intellicode only (xtr-96 gives empty $output):
    my $re = qr{(.*)};
    my ($output) = $t->waitfor(Match => "/$re/", Timeout => undef); # no timeout
#=cut
    say $t->errmsg if $t->errmsg;
    $t->close; # p $output;
	do_extract($output);
    say "do_waitfor_method for $host";
}

sub do_cmd_method {
    my $t = Net::Telnet->new(@_);

    my @host = ( Host => $host, Port => $port );
    unless ( $t->open(@host) ) { # returns 1 on success, 0 on failure:
        die $t->errmsg;
    }
	my $ref;
	my @data = $t->getlines(Timeout => 30); p @data;
    my $line = $t->lastline; p $line;
	$t->dump_log();
}

sub do_intellicode_method { # return extract_xml( _read_xml() );
	my @args = (
		# Timeout	=> 15, done in waitfor() now otherwise processes delay until $secs
		Errmode	=> 'return', # don't die (default)
#		Input_Log 	=> './xtr-96.log', # uncomment to debug
	);
	my $t = Net::Telnet->new(@args);
$t->input_log('telnet.log');
	my @host = ( Host => $host, Port => $port ); # p @host;
	unless ( $t->open(@host) ) { # returns 1 on success, 0 on failure:
		die $t->errmsg;
	}
    # initiate plate read:
say sprintf 'opened ftp connection: %.2f sec', tv_interval $t0, [gettimeofday];
    $t->cmd(
        String  => 'Intellicode.Instrument.Profile.load( fluidx 48.xtprof )',
        Timeout => 0
    );
    $t->waitfor(String => 'success:load');
say sprintf 'profile loaded, initiating scan: %.2f sec', tv_interval $t0, [gettimeofday];
	$t->cmd(
        String  => 'Intellicode.Instrument.Profile.scan',
        Timeout => 0,
    );
    $t->waitfor(String => 'success:scan');
say sprintf 'completed scan: %.2f sec', tv_interval $t0, [gettimeofday];
    # get results:
    $t->cmd(
        String  => 'Intellicode.Instrument.Profile.Exporter.getResults(xml_exporter)',
        Timeout => 0,
    ); # p $t;
    # my $ref = $t->buffer; # p $ref; # captures all output
    my ($prematch, $match) = $t->waitfor(String => 'success:getResults');
say sprintf 'returned results: %.2f sec', tv_interval $t0, [gettimeofday];
    unless ($prematch) {
        die ${ $t->buffer }; # send this back as error
    } p $prematch;
    my ($xml) = $prematch =~ /msg:(.*)/ms; # p $xml;
    $t->input_log('');
    my $plate_data = extract_xml($xml); # p $plate_data;
say sprintf 'extracted xml: %.2f sec', tv_interval $t0, [gettimeofday];
}

sub extract_xml { # original intellicode xml
    my $xml = shift; # p $xml;
    my $ref = XMLin($xml, ForceArray => 0, KeyAttr => []); # p $ref; exit;

    my ($plate_id) = map $ref->{$_}, # linear or 2-d barcode reading:
        grep { $ref->{$_} =~ /\w+?\d+/ } qw/idlbc id2d/;
    my $well_data = $ref->{well};

    my %h = ( plateId => $plate_id );
    for my $well(@$well_data) { # p $well; next;
        my $well_id = $well->{id};
        my $value   = $well->{value};
        $h{data}{$well_id} = $value;
    }
    { # calculate max well position (D6, F8 or H12):
        my @wells  = Sort::Naturally::nsort( keys %{ $h{data} } ); # p @wells;
        my @alphanum_max = $wells[-1] =~ /([a-z])(\d+)/i; # p @alphanum_max;
        @{ $h{well_max} }{ qw/alpha_max numbr_max/ } = @alphanum_max;
    }  p %h;
    return \%h;
}

=begin
sub _extract_xml { # original intellicode xml
    my $xml = shift;
    my $ref = XMLin($xml, ForceArray => 0, KeyAttr => []);  p $ref; exit;

    my $data = $ref->{ValueList}
        ->{NvPair}
        ->[0]
        ->{ValueList}
        ->{NvPair}
        ->[0]
        ->{ValueList}
        ->{NvPair}
    ; # p $data;
    my %h;
    for my $well(@$data) { # p $well; next;
        my $well_name = $well->{Name};
        my $result    = $well->{ValueList}->{NvPair}->{Name};

        if ($well_name =~ /Count/) { # FailCount, SuccessCount
            $h{outcome}{$well_name} = $result;
            next;
        }
        $h{data}{$well_name} = $result;
    } # p %h;
    return \%h;
}
=cut

sub do_extract {
	my $string = shift; # say $string; die '$string empty' unless $string;

	my ($plateId, $str)
		= $string =~ /Rack Identifier = ([A-Z0-9]+)\s+(A01,.*)/;
    say sprintf qq!cannot extract data from output: $string! and return 0 unless $str;
	$str =~ s/\s//g; # remove (arbitrary?) spaces

	my %plate_data = split /,\s?/, $str;
	p %plate_data; p $plateId;
}

sub connect_and_get {
    my $t = Net::Telnet->new(@_);

    my @host = ( Host => $host, Port => $port );
    unless ( $t->open(@host) ) { # returns 1 on success, 0 on failure:
        die $t->errmsg;
    }
    # initiate plate read:
    $t->cmd('get');

    return $t;
}

sub _read_xml {
    return q!<?xml version="1.0" encoding="UTF-8"?>
<group name="" id2d="NO READ" idlbc="SA00343341">
        <well id="A1" value="NO READ"/>
        <well id="A2" value="NO READ"/>
        <well id="A3" value="NO READ"/>
        <well id="A4" value="NO READ"/>
        <well id="A5" value="NO READ"/>
        <well id="A6" value="NO READ"/>
        <well id="A7" value="NO READ"/>
        <well id="A8" value="NO READ"/>
        <well id="A9" value="NO READ"/>
        <well id="A10" value="NO READ"/>
        <well id="A11" value="NO READ"/>
        <well id="A12" value="NO READ"/>
        <well id="B1" value="NO READ"/>
        <well id="B2" value="NO READ"/>
        <well id="B3" value="NO READ"/>
        <well id="B4" value="NO READ"/>
        <well id="B5" value="NO READ"/>
        <well id="B6" value="NO READ"/>
        <well id="B7" value="NO READ"/>
        <well id="B8" value="NO READ"/>
        <well id="B9" value="NO READ"/>
        <well id="B10" value="NO READ"/>
        <well id="B11" value="NO READ"/>
        <well id="B12" value="NO READ"/>
        <well id="C1" value="NO READ"/>
        <well id="C2" value="NO READ"/>
        <well id="C3" value="NO READ"/>
        <well id="C4" value="NO READ"/>
        <well id="C5" value="NO READ"/>
        <well id="C6" value="NO READ"/>
        <well id="C7" value="NO READ"/>
        <well id="C8" value="NO READ"/>
        <well id="C9" value="NO READ"/>
        <well id="C10" value="NO READ"/>
        <well id="C11" value="1030350658"/>
        <well id="C12" value="NO READ"/>
        <well id="D1" value="NO READ"/>
        <well id="D2" value="NO READ"/>
        <well id="D3" value="1030350595"/>
        <well id="D4" value="1030350603"/>
        <well id="D5" value="NO READ"/>
        <well id="D6" value="NO READ"/>
        <well id="D7" value="1030350627"/>
        <well id="D8" value="NO READ"/>
        <well id="D9" value="1030350643"/>
        <well id="D10" value="NO READ"/>
        <well id="D11" value="NO READ"/>
        <well id="D12" value="1030350667"/>
        <well id="E1" value="NO READ"/>
        <well id="E2" value="NO READ"/>
        <well id="E3" value="1030350596"/>
        <well id="E4" value="1030350604"/>
        <well id="E5" value="1030350612"/>
        <well id="E6" value="NO READ"/>
        <well id="E7" value="NO READ"/>
        <well id="E8" value="NO READ"/>
        <well id="E9" value="NO READ"/>
        <well id="E10" value="NO READ"/>
        <well id="E11" value="1030350660"/>
        <well id="E12" value="NO READ"/>
        <well id="F1" value="1030350581"/>
        <well id="F2" value="1030350589"/>
        <well id="F3" value="1030350597"/>
        <well id="F4" value="1030350605"/>
        <well id="F5" value="1030350613"/>
        <well id="F6" value="1030350621"/>
        <well id="F7" value="1030350629"/>
        <well id="F8" value="1030350637"/>
        <well id="F9" value="NO READ"/>
        <well id="F10" value="1030350653"/>
        <well id="F11" value="1030350661"/>
        <well id="F12" value="NO READ"/>
        <well id="G1" value="1030350582"/>
        <well id="G2" value="1030350590"/>
        <well id="G3" value="1030350598"/>
        <well id="G4" value="1030350606"/>
        <well id="G5" value="1030350614"/>
        <well id="G6" value="NO READ"/>
        <well id="G7" value="NO READ"/>
        <well id="G8" value="1030350638"/>
        <well id="G9" value="1030350646"/>
        <well id="G10" value="1030350654"/>
        <well id="G11" value="1030350662"/>
        <well id="G12" value="1030350670"/>
        <well id="H1" value="1030350583"/>
        <well id="H2" value="1030350591"/>
        <well id="H3" value="1030350599"/>
        <well id="H4" value="1030350607"/>
        <well id="H5" value="1030350615"/>
        <well id="H6" value="1030350623"/>
        <well id="H7" value="1030350631"/>
        <well id="H8" value="1030350639"/>
        <well id="H9" value="1030350647"/>
        <well id="H10" value="NO READ"/>
        <well id="H11" value="NO READ"/>
        <well id="H12" value="1030350671"/>
</group>
!;
}

=begin # original intellicode output:
sub _read_xml {
    return q!<?xml version="1.0" encoding="UTF-8"?>
<NvPair xmlns="http://schemas.datacontract.org/2004/07/Swark.Util.ImportExport" xmlns:i="http://www.w3.org/2001/XMLSchema-instance">
   <Filter>0</Filter>
   <Name>Root</Name>
   <UserData i:nil="true" />
   <ValueList>
      <NvPair>
         <Filter>0</Filter>
         <Name>imager</Name>
         <UserData i:nil="true" />
         <ValueList>
            <NvPair>
               <Filter>8</Filter>
               <Name>rack</Name>
               <UserData i:nil="true" />
               <ValueList>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>SuccessCount</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>0</Filter>
                           <Name>96</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>FailCount</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>0</Filter>
                           <Name>0</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>A1</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165120</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>A2</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165128</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>A3</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165136</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>A4</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165144</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>A5</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165152</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>A6</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165160</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>A7</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165168</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>A8</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165176</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>A9</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165184</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>A10</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165192</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>A11</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165200</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>A12</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165208</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>B1</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165121</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>B2</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165129</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>B3</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165137</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>B4</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165145</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>B5</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165153</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>B6</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165161</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>B7</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165169</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>B8</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165177</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>B9</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165185</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>B10</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165193</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>B11</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165201</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>B12</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165209</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>C1</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165122</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>C2</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165130</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>C3</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165138</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>C4</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165146</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>C5</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165154</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>C6</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165162</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>C7</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165170</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>C8</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165178</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>C9</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165186</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>C10</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165194</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>C11</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165202</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>C12</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165210</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>D1</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165123</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>D2</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165131</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>D3</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165139</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>D4</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165147</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>D5</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165155</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>D6</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165163</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>D7</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165171</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>D8</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165179</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>D9</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165187</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>D10</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165195</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>D11</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165203</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>D12</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165211</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>E1</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165124</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>E2</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165132</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>E3</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165140</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>E4</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165148</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>E5</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165156</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>E6</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165164</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>E7</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165172</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>E8</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165180</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>E9</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165188</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>E10</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165196</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>E11</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165204</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>E12</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165212</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>F1</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165125</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>F2</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165133</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>F3</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165141</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>F4</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165149</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>F5</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165157</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>F6</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165165</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>F7</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165173</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>F8</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165181</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>F9</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165189</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>F10</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165197</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>F11</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165205</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>F12</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165213</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>G1</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165126</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>G2</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165134</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>G3</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165142</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>G4</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165150</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>G5</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165158</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>G6</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165166</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>G7</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165174</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>G8</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165182</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>G9</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165190</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>G10</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165198</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>G11</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165206</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>G12</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165214</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>H1</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165127</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>H2</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165135</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>H3</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165143</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>H4</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165151</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>H5</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165159</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>H6</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165167</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>H7</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165215</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>H8</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165207</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>H9</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165199</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>H10</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165191</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>H11</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165183</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>H12</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>34</Filter>
                           <Name>1035165175</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
               </ValueList>
            </NvPair>
            <NvPair>
               <Filter>0</Filter>
               <Name>2d_rackid_1</Name>
               <UserData i:nil="true" />
               <ValueList>
                  <NvPair>
                     <Filter>0</Filter>
                     <Name>ID</Name>
                     <UserData i:nil="true" />
                     <ValueList>
                        <NvPair>
                           <Filter>33</Filter>
                           <Name>SA00584054</Name>
                           <UserData i:nil="true" />
                           <ValueList />
                        </NvPair>
                     </ValueList>
                  </NvPair>
               </ValueList>
            </NvPair>
         </ValueList>
      </NvPair>
      <NvPair>
         <Filter>0</Filter>
         <Name>UserName</Name>
         <UserData i:nil="true" />
         <ValueList>
            <NvPair>
               <Filter>0</Filter>
               <Name>cooperdd</Name>
               <UserData i:nil="true" />
               <ValueList />
            </NvPair>
         </ValueList>
      </NvPair>
      <NvPair>
         <Filter>0</Filter>
         <Name>MachineName</Name>
         <UserData i:nil="true" />
         <ValueList>
            <NvPair>
               <Filter>0</Filter>
               <Name>LTH203595</Name>
               <UserData i:nil="true" />
               <ValueList />
            </NvPair>
         </ValueList>
      </NvPair>
      <NvPair>
         <Filter>0</Filter>
         <Name>Time</Name>
         <UserData i:nil="true" />
         <ValueList>
            <NvPair>
               <Filter>0</Filter>
               <Name>04 July 2018</Name>
               <UserData i:nil="true" />
               <ValueList />
            </NvPair>
         </ValueList>
      </NvPair>
   </ValueList>
</NvPair>
!;
}
=cut

__END__

Intellicode output using:
    my $re = qr{(.*)$};
    my ($output) = $t->waitfor(Match => "/$re/", Timeout => undef);
=====================================================================

xtr-96 Connected

Reading...

Rack Identifier = SA00136849
A01, FR09988928, A02, FR09988848,  A03, FR09988856, A04, FR09988864, A05, FR09988872, A06, FR09988880, A07, FR09988888, A08, FR09988896, A09, FR09988904, A10, FR09988912, A11, FR09988920, A12, FR09988891, B01, FR09988841, B02, FR09988849, B03, FR09988857, B04, FR09988865, B05, FR09988873, B06, FR09988881, B07, FR09988889, B08, FR09988897, B09, FR09988905, B10, FR09988913, B11, FR09988921, B12, FR09988929, C01, FR09988842, C02, FR09988850, C03, FR09988858, C04, FR09988866, C05, FR09988874, C06, FR09988882, C07, FR09988890, C08, FR09988898, C09, FR09988906, C10, FR09988914, C11, FR09988922, C12, FR09988930, D01, FR09988843, D02, FR09988851, D03, FR09988859, D04, FR09988867, D05, FR09988875, D06, FR09988883, D07, FR09988847, D08, FR09988899, D09, FR09988907, D10, FR09988915, D11, FR09988923, D12, FR09988931, E01, FR09988844, E02, FR09988852, E03, FR09988860, E04, FR09988868, E05, FR09988876, E06, FR09988884, E07, FR09988892, E08, FR09988900, E09, FR09988908, E10, FR09988916, E11, FR09988924, E12, FR09988932, F01, FR09988845, F02, FR09988853, F03, FR09988861, F04, FR09988869, F05, FR09988877, F06, FR09988885, F07, FR09988893, F08, FR09988901, F09, FR09988909, F10, FR09988917, F11, FR09988925, F12, FR09988933, G01, FR09988846, G02, FR09988854, G03, FR09988862, G04, FR09988870, G05, FR09988878, G06, FR09988886, G07, FR09988894, G08, FR09988902, G09, FR09988910, G10, FR09988918, G11, FR09988926, G12, FR09988934, H01, FR09988935, H02, FR09988855, H03, FR09988863, H04, FR09988871, H05, FR09988879, H06, FR09988887, H07, FR09988895, H08, FR09988903, H09, NO TUBE, H10, 1025448211, H11, 1025448489, H12, 1025448243
=====================================================================

XTR-96 output using:
    my $re = qr{H12,(.*)$}; # end of output = H12,<result>
    my ($prematch, $match) = $t->waitfor(Match => "/$re/", Timeout => undef); # no timeout
    my $output = join '', $prematch, $match;

=====================================================================
xtr-96 ConnectedReading...Rack Identifier = SA00083770
A01,No Tube,B01,1020861345,C01,1020861346,D01,1020861347,E01,1020861348,F01,1020861349,G01,1020861350,H01,1020861351,A02,No Tube,B02,1020861353,C02,1020861354,D02,1020861355,E02,1020861356,F02,1020861357,G02,1020861358,H02,1020861359,A03,No Tube,B03,1020861361,C03,1020861362,D03,1020861363,E03,1020861364,F03,1020861365,G03,1020861366,H03,1020861367,A04,No Tube,B04,1020861369,C04,1020861370,D04,1020861371,E04,1020861372,F04,1020861373,G04,1020861374,H04,1020861375,A05,No Tube,B05,1020861377,C05,1020861378,D05,1020861379,E05,1020861380,F05,1020861381,G05,1020861382,H05,1020861383,A06,No Tube,B06,1020861385,C06,1020861386,D06,1020861387,E06,1020861388,F06,1020861389,G06,1020861390,H06,1020861391,A07,No Tube,B07,1020861393,C07,1020861394,D07,1020861395,E07,1020861396,F07,1020861397,G07,1020861398,H07,1020861399,A08,No Tube,B08,1020861401,C08,1020861402,D08,1020861403,E08,1020861404,F08,1020861405,G08,1020861406,H08,1020861407,A09,No Tube,B09,1020861409,C09,1020861410,D09,1020861411,E09,1020861412,F09,1020861413,G09,1020861414,H09,1020861415,A10,No Tube,B10,1020861417,C10,1020861418,D10,1020861419,E10,1020861420,F10,1020861421,G10,1020861422,H10,1020861423,A11,1020861424,B11,1020861425,C11,1020861426,D11,1020861427,E11,1020861428,F11,1020861429,G11,1020861430,H11,1020861431,A12,1020861432,B12,1020861433,C12,1020861434,D12,1020861435,E12,1020861436,F12,1020861437,G12,1020861438,H12,1020861439
=====================================================================
