package LIMS::DB::Outreach::PatientAlternateAddress;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    schema  => 'outreach',

    table   => 'patient_alternate_address',

    columns => [
        patient_id => { type => 'integer', not_null => 1 },
        address    => { type => 'varchar', length => 255, not_null => 1 },
        post_code  => { type => 'varchar', length => 8, not_null => 1 },
    ],

    primary_key_columns => [ 'patient_id' ],

    foreign_keys => [
        patient => {
            class       => 'LIMS::DB::Patient',
            key_columns => { patient_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('patient_alternate_addresses');

1;