package HMDS::Perl 0.01;
## no critic 'RequirePodSections'

use Modern::Perl '2012';
use Carp;
use Import::Into;

use autodie  ();
use indirect ();
use mro      ();
use English qw( -no_match_vars );
use Const::Fast;

# This adds the UTF-8 layer on STDIN, STDOUT, STDERR for _everyone_
use open qw( :encoding(UTF-8) :std );
use utf8 ();
use Try::Tiny;
use DateTime;

sub import {
    my $caller_level = 1;

    Modern::Perl->import::into($caller_level);

    mro::set_mro( scalar caller(), 'c3' );
    utf8->import::into($caller_level);

    indirect->unimport::out_of( $caller_level, ':fatal' );

    'open'->import::into( $caller_level, ':encoding(UTF-8)' );
    autodie->import::into( $caller_level, ':all' );
    English->import::into( $caller_level, '-no_match_vars' );
    DateTime->import::into($caller_level);
    Try::Tiny->import::into($caller_level);
    Const::Fast->import::into($caller_level);
    return;
}
1;

__END__
=pod


=encoding utf8

=for stopwords HMDS::Perl autodie

=head1 NAME

HMDS::Perl - stuff to import everywhere

=head1 VERSION

Version 0.01

=head1 SYNOPSIS

C<use HMDS::Perl>

=head1 DESCRIPTION

Strictures and modules to standardise HILIS4 code

=over 4

=item uses const::Fast instead of constant

=item doesn't allow indirect notation, e.g. my $o = new Thing;

=item uses autodie

=item uses Try::Tiny for exception handling

=item uses English for clearer code, e.g, $OS_ERROR instead of $!

=item uses utf-8 for unicode in source «yay!»

=back

#=head1 SUBROUTINES/METHODS
#
#=head1 DIAGNOSTICS
#
#=head1 CONFIGURATION AND ENVIRONMENT
#
=head1 DEPENDENCIES

Const::Fast

Try::Tiny


=head1 BUGS AND LIMITATIONS

This is a first stab at a HMDS module so is likely to change a fair bit

=head1 AUTHOR

Garry Quested <garry.quested@nhs.net>

=head1 SEE ALSO

perl(1).

=head1 LICENSE AND COPYRIGHT

Copyright (c) 2018, HMDS.  All Rights Reserved.

This script is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.


