package LIMS::Controller::Local::Worklist::Preregistration; # only ucfirst or need an entry in Dispatch

use base 'LIMS::Base';
use Data::Printer;

use strict;

# ------------------------------------------------------------------------------
sub edit : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
	my $errs = shift; # $self->stash( errs => $errs );

    # pre_registration_id:
	my $id = $self->param('id')
	|| return $self->error( "no 'id' passed to " . $self->get_current_runmode );

    $self->js_validation_profile('pre_screen_data');
    # get unregistered request data as hashref (to add specimen/lab-test data):
    my $data = $self->model('Local')->get_unregistered_request($id)->as_tree;

	{ # get list of specimens already in use for this pre_registration.id:
		my $map = $self->_get_prereg_specimens($id); # p $map;
		$self->tt_params( specimens_map => $map );
	}

    # if (optional) pre_registration_specimen.id supplied:
	if ( my $rs_id = $self->param('Id') ) {
		my $ref = $self->model('Local')
            ->get_unregistered_request_specimen_lab_test($rs_id); # p $ref->as_tree;
        $data->{specimen_lab_test_data} = $ref->as_tree;

        my %lab_tests = map {
            $_->lab_test->test_name => 1;
        } @{ $ref->pre_registration_lab_test }; # p \%lab_tests;
        $data->{lab_tests} = \%lab_tests;
    } # p $data;
    $self->tt_params( request => $data );

    # add lab-section id to tt_params for tmpl hidden field:
    $self->_get_lab_section_id();

    my $tmpl = 'worklist/local/preregistration/'.$self->get_current_runmode.'.tt';
	return $self->tt_process($tmpl, $errs);
}

# ------------------------------------------------------------------------------
sub update : Runmode {
	my $self = shift; $self->_debug_path($self->get_current_runmode);

	# capture pre_registration.id:
	my $id = $self->param('id')
	|| return $self->error( "no 'id' passed to " . $self->get_current_runmode );
	# capture optional pre_registration_specimen.id:
	my $rs_id = $self->param('Id');

    my $dfv = $self->check_rm( 'pre_screen_data', $self->validate('pre_screen_data') )
    || return $self->dfv_error_page;

	my $data = $dfv->valid;
	$data->{id} = $id;
    $data->{pre_reg_specimen_id} = $rs_id;

	my $rtn = $self->model('Local')->update_pre_registration_data($data);
	if ($rtn) {
		return $self->error($rtn);
	}
	else {
		$self->flash( info => $self->messages('action')->{edit_success} );
		return $self->redirect( $self->query->url
			. '/local_worklist?function_name=pre_screen' );
	}
}

# ------------------------------------------------------------------------------
sub delete : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    my $id = $self->param('id')
    || return $self->error('no id passed to ' . $self->get_current_runmode);
    my $rs_id = $self->param('Id'); # optional (only if request_specimen exists)

    # need confirmation to delete record:
    if ( $self->query->param('confirm_delete') ) {
        my %h = (
            pre_reg_id => $id,
            pre_reg_specimen_id => $rs_id, # optional (only if specimen registered)
        );
        my $rtn = $self->model('Local')->delete_pre_registration_data(\%h);
        return $self->error($rtn) if $rtn;

        # set flash success & redirect:
        $self->flash( info => $self->messages('action')->{delete_success} );
        my $url = $self->query->url . '/local_worklist?function_name=pre_screen';
        return $self->redirect($url);
    }
    else { # just load data for confirmation:
        my $data = $self->model('Local')->get_unregistered_request($id)->as_tree;

        # if (optional) pre_registration_specimen.id supplied:
        if ( $rs_id ) {
            my $ref = $self->model('Local')
                ->get_unregistered_request_specimen_lab_test($rs_id); # p $ref->as_tree;
            $data->{specimen_lab_test_data} = $ref->as_tree;

            my %lab_tests = map {
                $_->lab_test->test_name => 1;
            } @{ $ref->pre_registration_lab_test }; # p \%lab_tests;
            $data->{lab_tests} = \%lab_tests;
        } # p $data;
        $self->tt_params( data => $data );
=begin # can delete this:
        # $id is either pre_registration.id or pre_registration.labno:
        my $col_name = ( $id =~ /\d{2}_\d+/ ) ? 'labno' : 'id'; # ie xx_xxxxx
        my @args = ( PreRegistration => { $col_name => $id } );
        my $data = $self->model('Base')->get_object_by_param(@args); # warn Dumper $data;
        $self->tt_params( data => $data );
=cut
		my $tmpl
            = 'worklist/local/preregistration/'.$self->get_current_runmode.'.tt';
        return $self->tt_process($tmpl);
    }
}

# ------------------------------------------------------------------------------
sub specimen_edit : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
	my $errs = shift; # $self->stash( errs => $errs );

	# capture pre_registration_specimen.id:
	my $id = $self->param('id')
	|| return $self->error( "no 'id' passed to " . $self->get_current_runmode );

	# request_specimen data:
	my $rs_data = $self->model('Local')->get_unregistered_request_specimen($id);
	$self->tt_params( request_specimen => $rs_data ); # warn Dumper $data->as_tree;

	{ # prereg_lab_test data map:
		my $data_map
			= $self->model('Local')->get_unregistered_request_lab_tests($id);
		# only 1 dataset in $data_map (only supplied 1 id), so extract it here:
		$self->tt_params( lab_tests => $data_map->{$id} ); # warn Dumper $data;
	}
	{ # get list of specimens already in use for this pre_registration.id:
		my $data
			= $self->model('Local')->get_prereg_specimens($rs_data->pre_reg->id);
		my %map = map {	$_->specimen_code => 1 }
			# skip specimen type of existing request_specimen entry:
			grep { $_->specimen_code ne $rs_data->specimen_code} @$data;
		$self->tt_params( specimens_map => \%map ); # warn Dumper \%map;
	}
    # add lab-section id to tt_params for tmpl hidden field:
    $self->_get_lab_section_id();

    $self->js_validation_profile('pre_screen_data');

	my $tmpl = 'worklist/local/preregistration/'.$self->get_current_runmode.'.tt';
	return $self->tt_process($tmpl, $errs);
}

# ------------------------------------------------------------------------------
sub specimen_update : Runmode {
	my $self = shift; $self->_debug_path($self->get_current_runmode);

	# capture pre_registration_specimen.id:
	my $id = $self->param('id')
	|| return $self->error( "no 'id' passed to " . $self->get_current_runmode );

    my $dfv = $self->check_rm( 'pre_screen_data', $self->validate('pre_screen_data') )
    || return $self->dfv_error_page;

	my $data = $dfv->valid;
	$data->{id} = $id; # warn Dumper $data;

	my $rtn = $self->model('Local')->update_pre_registration_specimen_data($data);

	if ($rtn) {
		return $self->error($rtn);
	}
	else {
		$self->flash( info => $self->messages('action')->{edit_success} );
		return $self->redirect( $self->query->url
			. '/local_worklist?function_name=pre_screen' );
	}
}

# ------------------------------------------------------------------------------
sub add_new : Runmode {
	my $self = shift; $self->_debug_path($self->get_current_runmode);
	my $errs = shift; # $self->stash( errs => $errs );

	# capture pre_registration.id:
	my $id = $self->param('id')
	|| return $self->error( "no 'id' passed to " . $self->get_current_runmode );

	{ # get data for pre_registration.id:
		my $data = $self->model('Local')->get_unregistered_request($id);
		$self->tt_params( prereg_data => $data ); # warn Dumper $data->as_tree;
	}
	{ # get list of specimens already in use for this pre_registration.id:
		my $map = $self->_get_prereg_specimens($id); # p $map;
		$self->tt_params( specimens_map => $map );
	}
    # add lab-section id to tt_params for tmpl hidden field:
    $self->_get_lab_section_id();

    $self->js_validation_profile('pre_screen_new');

	my $tmpl = 'worklist/local/preregistration/'.$self->get_current_runmode.'.tt';
	return $self->tt_process($tmpl, $errs);
}

# ------------------------------------------------------------------------------
sub new_data : Runmode {
	my $self = shift; $self->_debug_path($self->get_current_runmode);

	# capture pre_registration.id:
	my $id = $self->param('id')
	|| return $self->error( "no 'id' passed to " . $self->get_current_runmode );

    my $dfv = $self->check_rm( 'add_new', $self->validate('pre_screen_new') )
    || return $self->dfv_error_page;

	my $data = $dfv->valid;
	$data->{id} = $id; # warn Dumper $data;

	my $rtn = $self->model('Local')->new_pre_registration_data($data);

	if ($rtn) {
		return $self->error($rtn);
	}
	else {
		$self->flash( info => $self->messages('action')->{create_success} );
		return $self->redirect( $self->query->url
			. '/local_worklist?function_name=pre_screen' );
	}
}

# ------------------------------------------------------------------------------
sub _get_lab_section_id { # add lab-section id to tt_params for tmpl hidden field:
    my $self = shift;
	my $lab_section = $self->model('LabSection')
        ->get_lab_section_by_name('Flow cytometry');
	$self->tt_params( lab_section_id => $lab_section->id );
    return 0; # no return expected
}

# ------------------------------------------------------------------------------
sub _get_prereg_specimens {
    my ($self, $pre_reg_id) = @_;

    my $data = $self->model('Local')->get_prereg_specimens($pre_reg_id);
	my %map = map {	$_->specimen_code => 1 } @$data;
    return \%map;
}

1;
