package LIMS::DB::Outreach::RequestReportIssued;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    schema  => 'outreach',
    table   => 'request_report_issued',

    columns => [
        request_id => { type => 'integer', not_null => 1 },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('request_reports_issued');

1;