package LIMS::DB::ConsentOption;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    table   => 'consent_options',

    columns => [
        id            => { type => 'serial', not_null => 1 },
        consent_name  => { type => 'varchar', length => 255 },
        consent_label => { type => 'varchar', length => 255 },
        is_active     => { type => 'enum', check_in => [ 'yes', 'no' ],
                          default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [
        [ 'consent_name' ],
        [ 'consent_label' ],
    ],
    
    relationships => [
        request_option => {
            class      => 'LIMS::DB::RequestConsent',
            column_map => { id => 'option_id' },
            type       => 'one to many',
        },
    ],
);

#=cut

__PACKAGE__->meta->make_manager_class('consent_options');

1;
