package LIMS::DB::Outreach::QuestionnaireService;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    schema  => 'outreach',
    
    table   => 'questionnaire_service',
    
    columns => [
        request_id => { type => 'integer', not_null => 1 },
        opinion    => { type => 'enum', check_in => [ 'happy', 'unhappy' ] },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);
#=cut

__PACKAGE__->meta->make_manager_class('questionnaire_service');

1;
