package LIMS::DB::HospitalDepartment;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'hospital_departments',

    columns => [
        id           => { type => 'integer', not_null => 1 },
        display_name => { type => 'varchar', length => 50, not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'display_name' ],

    relationships => [
        referrer_department => {
            class      => 'LIMS::DB::ReferrerDepartment',
            column_map => { id => 'hospital_department_code' },
            type       => 'one to many',
        },
    ],
);

#__PACKAGE__->meta->table('hospital_departments');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 2);

__PACKAGE__->meta->make_manager_class('hospital_departments');

1;
