package LIMS::Controller::Roles::Resource;

use Moose::Role;
use Data::Dumper;

sub new_and_relapsed_diagnoses {
    my $self     = shift;
    my $org_code = shift; # optional
    
    my %data;
    
    { # get map of user locations => region_code:
        my $locations_map = $self->user_locations_map;
        $data{locations_map} = $locations_map;
    }

    # if we have an org_code to search on:
    if ($org_code) {
        my $duration = $self->query->param('duration') || 7; # default
    
        my %args = (
            org_code => $org_code,
            duration => $duration,
        );

        my $data = $self->model('Request')->get_new_and_relapsed_cases(\%args);
        # sort data by report_history.time since Rose can't do it:
        my @sorted = sort { # warn Dumper $a->request_history->time;
            my $A = $a->request_history->[0]->time->truncate( to => 'day' ); 
            my $B = $b->request_history->[0]->time->truncate( to => 'day' );
			
            DateTime->compare( $A, $B ) # date 1st 
                || $a->year <=> $b->year # year 2nd
                    || $a->request_number <=> $b->request_number; # req_no 3rd	
        } @$data; # warn Dumper \@sorted;
        
        $data{results} = \@sorted;
    }
    
    return \%data;
}

sub get_admin_messages {
    my ($self, $user_location) = @_;
    
    my $user_type = # is user internal or external?
        $user_location eq $self->cfg('settings')->{lab_name_abbreviation}
        ? 'internal'
        : 'external';

    my $messages = $self->model('User')->get_admin_messages($user_type);
    return $messages;
}

sub get_user_messages {
    my ($self, $user_id) = @_;
    
    my $messages = $self->model('User')->get_user_messages($user_id);
    return $messages;
}

1;