package LIMS::Model::Roles::SessionData;

use Moose::Role;
use namespace::clean -except => 'meta';

has _session => (
    is        => 'ro',
    isa       => 'CGI::Session',
    required  => 1,
);
 
sub session_data {
    my ($self, $param_name) = @_; # name of session param containing required data

    my $session = $self->_session; 
  
    my $data = $session->param($param_name); # use Data::Dumper; warn Dumper $data;
    return $data;
}

sub user_profile {
    my $self = shift;
    
    return $self->session_data('UserProfile');
}

sub clear_data {
    my ($self, $param_name) = @_;
    
    $self->_session->clear($param_name);
}

1;
