#!/usr/bin/perl -w

use strict;

BEGIN { # set active db to production - default is `test`
    use FindBin qw($Bin); # warn 'BIN:'.$Bin;
    # set lib paths for app:
    use lib (
        '/home/raj/perl5/lib/perl5',
        "$Bin/../lib",
        "$Bin/..",
    );

    # override default db test:
    $ENV{ROSEDB_DEVINIT} = "$Bin/../config/rosedb_devinit_prod.pl";
    # set flag for LIMS::_set_cgisession_options & QueryLog:
    $ENV{FAST_CGI} = 1;
}

use CGI::Fast();
use LIMS::Dispatch;

=begin
use FCGI::ProcManager;

my $proc_manager = FCGI::ProcManager->new({processes => 2});
$proc_manager->pm_manage();
=cut

while ( my $q = CGI::Fast->new() ) {
#    $proc_manager -> pm_pre_dispatch();
    
    eval {
        LIMS::Dispatch->dispatch(
            args_to_new => { QUERY => $q },
            default => '',
            debug => 0,
        );
    };

#    $proc_manager -> pm_post_dispatch();
    
	#warn $@ if $@;
	my $err = $@;
	if ($err) {
		warn "$0 error: $err";
		exit 0; # to free $dbh from stuck transaction and restart process(es)
	}
}



