#!/usr/bin/perl -w

BEGIN {
    use FindBin qw($RealBin); # warn $FindBin::RealBin;

	use lib (
        "$RealBin/../lib",
        "$RealBin/../setup/hilis3_convert",
		'/home/raj/perl5/lib/perl5',
	);

    use vars qw($SQL_FOR_TABLE $FOREIGN_KEYS);
    require "$RealBin/../setup/lims.sql";
}

use strict;
use warnings;

use DateTime;
use Data::Dumper;
use Config::Tiny;

use DB;
use Main;
use User;
use YHHN;
use Consent;
use History;
use LabTest;
use Referrer;
use Outreach;
use PreScreen;
use RequestLog;
# use TestResult; # combined with LabTest now
use RequestAudit;
use PatientTrial;
use ReferralSource;

my $src = "$RealBin/../setup/hilis3_convert/.db";
my $cfg = Config::Tiny->read($src); # warn Dumper $cfg; exit;

my $DB = DB->new(config => $cfg);

# hashref of DBI & DBIx::Simple db handles for source(hilis3) & destination (hilis4) dbs:
my $db = $DB->connect;

open my $log, '>', "$RealBin/../setup/hilis3_convert/convert.log" or die $!;

my %args = (
	db  => $db,
	sql => {
		table => $SQL_FOR_TABLE,
	},
	path_to_app => "$RealBin/../", # /home/raj/www/apps/HMDS/trunk
    log_file => $log,
);

my $start = DateTime->now(time_zone => 'local'); print $start->datetime, "\n";

do_yhhn(); exit;
# remove_fks(); # exit;
# methods to run:
#------------------------------------------------------------------------------#
do_referral_sources();
do_users(); 
do_referrers(); 
do_main_conversion();
do_lab_tests();
do_patient_trial();
do_request_audit();
do_consent();
do_request_logs();
do_prescreen();
do_history();
do_yhhn(); # MUST BE DONE BEFORE OUTREACH - patient_demographics table
#do_outreach(); # requires hilis3 db *not older than* community_monitoring db 
##do_test();
#------------------------------------------------------------------------------#

restore_fks();

$DB->disconnect($db);

my $finish = DateTime->now(time_zone => 'local');
my $duration = $finish->subtract_datetime($start);

printf "Process ran for %s hrs %s mins %s secs\n\n",
	$duration->hours, $duration->minutes, $duration->seconds;

sub do_referral_sources {
	my $o = ReferralSource->new(%args);
	$o->convert;
}

sub do_referrers {
	my $o = Referrer->new(%args);
	$o->convert;
}

sub do_main_conversion {
    $args{cfg} = $cfg; # for Patient to anonymise names
	my $o = Main->new(%args);
	$o->convert;
}

sub do_users {
	my $o = User->new(%args);
	$o->convert;
}

sub do_history {
	my $o = History->new(%args);
	$o->convert;
}

sub do_patient_trial {
	my $o = PatientTrial->new(%args);
	$o->convert;
}

sub do_consent {
	my $o = Consent->new(%args);
	$o->convert;
}

sub do_request_audit {
	my $o = RequestAudit->new(%args);
	$o->convert;
}

sub do_lab_tests {
	my $o = LabTest->new(%args);
	$o->convert;
}

sub do_test_results {
	my $o = TestResult->new(%args);
	$o->convert;
}

sub do_request_logs {
    my $o = RequestLog->new(%args);
	$o->convert;
}

sub do_prescreen {
    my $o = PreScreen->new(%args);
	$o->convert;
}

sub do_outreach {
	my $o = Outreach->new(%args);
	$o->convert;
}

sub do_yhhn {
	my $o = YHHN->new(%args);
	$o->convert;
}

sub do_test {
    use Test;
	Test->new(%args)->block_ref;
}

sub remove_fks {
	my $dbh = $db->{dbh4};
	
	print "Removing FK's .... ";
	
	foreach my $fk ( sort keys %$FOREIGN_KEYS ) {
		my ($tbl) = $fk =~ /fk_(.*)/; # print Dumper $tbl;

		my (@fks) = $FOREIGN_KEYS->{$fk} =~ /(\w+_ibfk_\d)/g; # print Dumper \@fks;

		map { # print qq!ALTER TABLE `$tbl` DROP FOREIGN KEY `$_`!;
			$db->{dbh4}->do( qq!ALTER TABLE `$tbl` DROP FOREIGN KEY `$_`! ); #print " .. OK\n";
		} @fks;
    }
	print "done\n";
}

sub restore_fks {
	my $dbh = $db->{dbh4};

	print "Restoring FK's .... ";
	
	foreach my $fk ( sort keys %$FOREIGN_KEYS ) {  #print $FOREIGN_KEYS->{$fk};
        $dbh->do( $FOREIGN_KEYS->{$fk} );  #print " .. OK\n";
    }
	print "done\n";
}
