package LIMS::RDBO;

# base class for all LIMS::DB::* classes which need to initialise db connection
# (sub init_db {LIMS::DB->new })

use strict;
use warnings;
use Data::Dumper;
use LIMS::DB;

use base qw(Rose::DB::Object);

BEGIN {
	$Rose::DB::Object::Debug =
        $Rose::DB::Object::Manager::Debug =
            ! $ENV{HARNESS_ACTIVE}; # sql output unless test harness running
#	0; # using DBIx::Log4perl instead

    # idea from http://www.mail-archive.com/cgiapp@lists.erlbaum.net/msg02886.html :
    # $SIG{__WARN__} = sub { LIMS::Local::QueryLog->log->warn(shift) };

    # this works, but dumps all warns to file, not just RDBO ones !!
    # $SIG{__WARN__} = sub { &_warn_handler(@_); }

	# use LIMS::Local::QueryLog; # moved to LIMS so it can pass authen->username
}

use Rose::DB::Object::Helpers qw(
	column_value_pairs
	insert_or_update
	load_speculative
	load_or_insert
	dirty_columns
	as_tree
	clone
);

sub init_db { LIMS::DB->new_or_cached; }
# sub init_db { my $o = LIMS::DB->new_or_cached; warn Dumper $o; return $o }

=begin
sub init_db {
    my $dbh = LIMS::DB->new_or_cached; # not sure this is safe for transactions - see README

    #use DBI::Profile;
	#$dbh->{Profile} = DBI::Profile->new();
	#$dbh->{Profile} = 2;

    return $dbh;
}
=cut

1;